/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.beans.PropertyValues;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledResourceChainCondition
extends SpringBootCondition {
    OnEnabledResourceChainCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        ResourceProperties properties = new ResourceProperties();
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)properties, "spring.resources");
        binder.bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)environment.getPropertySources()));
        Boolean match = properties.getChain().getEnabled();
        return new ConditionOutcome(match, "Resource chain is " + (match != false ? "enabled" : "disabled"));
    }
}

