/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.mail;

import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailHealthIndicator
extends AbstractHealthIndicator {
    private final JavaMailSenderImpl mailSender;

    public MailHealthIndicator(JavaMailSenderImpl mailSender) {
        super("Mail health check failed");
        this.mailSender = mailSender;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        int port = this.mailSender.getPort();
        builder.withDetail("location", port != -1 ? this.mailSender.getHost() + ":" + this.mailSender.getPort() : this.mailSender.getHost());
        this.mailSender.testConnection();
        builder.up();
    }
}

