/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.List;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.ElasticsearchHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;

public class ElasticsearchHealthIndicator
extends AbstractHealthIndicator {
    private static final String[] allIndices = new String[]{"_all"};
    private final Client client;
    private final ElasticsearchHealthIndicatorProperties properties;

    public ElasticsearchHealthIndicator(Client client, ElasticsearchHealthIndicatorProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        List<String> indices = this.properties.getIndices();
        ClusterHealthResponse response = (ClusterHealthResponse)this.client.admin().cluster().health(Requests.clusterHealthRequest((String[])(indices.isEmpty() ? allIndices : indices.toArray(new String[indices.size()])))).actionGet(this.properties.getResponseTimeout());
        switch (response.getStatus()) {
            case GREEN: 
            case YELLOW: {
                builder.up();
                break;
            }
            default: {
                builder.down();
            }
        }
        builder.withDetail("clusterName", response.getClusterName());
        builder.withDetail("numberOfNodes", response.getNumberOfNodes());
        builder.withDetail("numberOfDataNodes", response.getNumberOfDataNodes());
        builder.withDetail("activePrimaryShards", response.getActivePrimaryShards());
        builder.withDetail("activeShards", response.getActiveShards());
        builder.withDetail("relocatingShards", response.getRelocatingShards());
        builder.withDetail("initializingShards", response.getInitializingShards());
        builder.withDetail("unassignedShards", response.getUnassignedShards());
    }
}

