/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.data;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.PropertiesAutoTimer;
import org.springframework.boot.actuate.autoconfigure.metrics.data.MetricsRepositoryMethodInvocationListenerBeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.data.DefaultRepositoryTagsProvider;
import org.springframework.boot.actuate.metrics.data.MetricsRepositoryMethodInvocationListener;
import org.springframework.boot.actuate.metrics.data.RepositoryTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.repository.Repository;
import org.springframework.util.function.SingletonSupplier;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={Repository.class})
@ConditionalOnBean(value={MeterRegistry.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class RepositoryMetricsAutoConfiguration {
    private final MetricsProperties properties;

    public RepositoryMetricsAutoConfiguration(MetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RepositoryTagsProvider.class})
    public DefaultRepositoryTagsProvider repositoryTagsProvider() {
        return new DefaultRepositoryTagsProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricsRepositoryMethodInvocationListener metricsRepositoryMethodInvocationListener(ObjectProvider<MeterRegistry> registry, RepositoryTagsProvider tagsProvider) {
        MetricsProperties.Data.Repository properties = this.properties.getData().getRepository();
        return new MetricsRepositoryMethodInvocationListener(() -> registry.getObject(), tagsProvider, properties.getMetricName(), (AutoTimer)new PropertiesAutoTimer(properties.getAutotime()));
    }

    @Bean
    public static MetricsRepositoryMethodInvocationListenerBeanPostProcessor metricsRepositoryMethodInvocationListenerBeanPostProcessor(ObjectProvider<MetricsRepositoryMethodInvocationListener> metricsRepositoryMethodInvocationListener) {
        return new MetricsRepositoryMethodInvocationListenerBeanPostProcessor((SingletonSupplier<MetricsRepositoryMethodInvocationListener>)SingletonSupplier.of(() -> metricsRepositoryMethodInvocationListener.getObject()));
    }
}

