/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.SpecializedMimeMessageProducer;

class MimeMessageProducerMixedRelated
extends SpecializedMimeMessageProducer {
    MimeMessageProducerMixedRelated() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        return MimeMessageProducerMixedRelated.emailContainsMixedContent(email) && MimeMessageProducerMixedRelated.emailContainsRelatedContent(email) && !MimeMessageProducerMixedRelated.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(MimeMessage message, Email email, EmailGovernance emailGovernance) throws MessagingException {
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, emailGovernance, multipartStructureWrapper.multipartRelated);
        MimeMessageHelper.configureForwarding(email, emailGovernance, multipartStructureWrapper.multipartRootMixed);
        MimeMessageHelper.setEmbeddedImages(email, emailGovernance, multipartStructureWrapper.multipartRelated);
        MimeMessageHelper.setAttachments(email, emailGovernance, multipartStructureWrapper.multipartRootMixed);
        message.setContent((Multipart)multipartStructureWrapper.multipartRootMixed);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            try {
                this.multipartRootMixed.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

