/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.ow2asm.signature.SignatureReader;
import org.simpleflatmapper.ow2asm.signature.SignatureVisitor;
import org.simpleflatmapper.reflect.ParameterizedTypeImpl;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class AsmUtils {
    public static final String ASM_DUMP_TARGET_DIR = "asm.dump.target.dir";
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final int API = 589824;
    static final Map<Class<?>, Class<?>> wrappers = new HashMap();
    static final Map<Class<?>, String> primitivesType;
    static final Map<String, String> stringToPrimitivesType;
    static final Map<Class<?>, Integer> loadOps;
    static final Map<Class<?>, Integer> storeOps;
    static final Map<Class<?>, Integer> returnOps;
    static final Map<Class<?>, Integer> defaultValue;
    static final Set<Class<?>> primitivesClassAndWrapper;
    static File targetDir;

    public static String toAsmType(String name) {
        return name.replace('.', '/');
    }

    public static String toAsmType(Type type) {
        if (TypeHelper.isPrimitive((Type)type)) {
            return primitivesType.get(TypeHelper.toClass((Type)type));
        }
        return AsmUtils.toAsmType(TypeHelper.toClass((Type)type).getName());
    }

    public static String toTargetTypeDeclaration(Type targetType) {
        if (TypeHelper.isPrimitive((Type)targetType)) {
            return primitivesType.get(TypeHelper.toClass((Type)targetType));
        }
        return AsmUtils.toTargetTypeDeclaration(AsmUtils.toAsmType(targetType));
    }

    public static String toTargetTypeDeclaration(String targetType) {
        if (targetType.startsWith("[")) {
            return targetType;
        }
        return "L" + targetType + ";";
    }

    public static String toGenericAsmType(Type type) {
        StringBuilder sb = new StringBuilder();
        sb.append(AsmUtils.toAsmType(type));
        Type[] typeParameters = null;
        if (type instanceof ParameterizedType) {
            typeParameters = ((ParameterizedType)type).getActualTypeArguments();
        }
        if (typeParameters != null && typeParameters.length > 0) {
            sb.append("<");
            for (Type t : typeParameters) {
                sb.append(AsmUtils.toTargetTypeDeclaration(AsmUtils.toGenericAsmType(t)));
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static byte[] writeClassToFile(String className, byte[] bytes) throws IOException {
        return AsmUtils.writeClassToFileInDir(className, bytes, targetDir);
    }

    public static byte[] writeClassToFileInDir(String className, byte[] bytes, File targetDir) throws IOException {
        if (targetDir != null) {
            AsmUtils._writeClassToFileInDir(className, bytes, targetDir);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _writeClassToFileInDir(String className, byte[] bytes, File targetDir) throws IOException {
        int lastIndex = className.lastIndexOf(46);
        String filename = className.substring(lastIndex + 1) + ".class";
        String directory = className.substring(0, lastIndex).replace('.', '/');
        File packageDir = new File(targetDir, directory);
        packageDir.mkdirs();
        try (FileOutputStream fos = new FileOutputStream(new File(packageDir, filename));){
            fos.write(bytes);
        }
    }

    public static Type toGenericType(String sig, List<String> genericTypeNames, Type target) throws ClassNotFoundException {
        ClassLoader classLoader = TypeHelper.getClassLoader((Type)target, (ClassLoader)Thread.currentThread().getContextClassLoader());
        SignatureReader reader = new SignatureReader(sig);
        final ArrayList types = new ArrayList();
        TypeCreator typeCreator = new TypeCreator((Consumer)new Consumer<Type>(){

            public void accept(Type t) {
                types.add(t);
            }
        }, classLoader, (List)genericTypeNames, target){};
        reader.accept((SignatureVisitor)typeCreator);
        typeCreator.visitEnd();
        return (Type)types.get(0);
    }

    public static Type findClosestPublicTypeExposing(Type type, Class<?> expose) {
        return AsmUtils.findTypeInHierarchy(type, new TypeIsPublicAndImplement(expose));
    }

    public static Type findTypeInHierarchy(Type type, Predicate<Type> predicate) {
        if (predicate.test((Object)type)) {
            return type;
        }
        Class targetClass = TypeHelper.toClass((Type)type);
        for (Type i : targetClass.getGenericInterfaces()) {
            if (!predicate.test((Object)i)) continue;
            return i;
        }
        Type st = targetClass.getGenericSuperclass();
        if (st != null) {
            return AsmUtils.findTypeInHierarchy(st, predicate);
        }
        return null;
    }

    public static void invoke(MethodVisitor mv, Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            mv.visitMethodInsn(184, AsmUtils.toAsmType(method.getDeclaringClass()), method.getName(), AsmUtils.toSignature(method), false);
        } else {
            AsmUtils.invoke(mv, method.getDeclaringClass(), method.getName(), AsmUtils.toSignature(method));
        }
    }

    public static void invoke(MethodVisitor mv, Type target, String method, String sig) {
        Type publicClass = AsmUtils.findTypeInHierarchy(target, new TypeIsPublicAndHasMethodMethod(method));
        boolean isInterface = TypeHelper.toClass((Type)publicClass).isInterface();
        mv.visitMethodInsn(isInterface ? 185 : 182, AsmUtils.toAsmType(publicClass), method, sig, isInterface);
    }

    public static Class<?> toWrapperClass(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isPrimitive()) {
            return wrappers.get(clazz);
        }
        return clazz;
    }

    public static String toWrapperType(Type type) {
        return AsmUtils.toAsmType(AsmUtils.toWrapperClass(type));
    }

    public static List<String> extractGenericTypeNames(String sig) {
        ArrayList<String> types = new ArrayList<String>();
        boolean nameDetected = false;
        int currentStart = -1;
        block4: for (int i = 0; i < sig.length(); ++i) {
            char c = sig.charAt(i);
            switch (c) {
                case ';': 
                case '<': {
                    if (nameDetected) continue block4;
                    nameDetected = true;
                    currentStart = i + 1;
                    continue block4;
                }
                case ':': {
                    types.add(sig.substring(currentStart, i));
                    nameDetected = false;
                }
            }
        }
        return types;
    }

    public static List<String> extractTypeNamesFromSignature(String sig) {
        final ArrayList<String> types = new ArrayList<String>();
        SignatureReader reader = new SignatureReader(sig);
        reader.accept(new SignatureVisitor(API){

            public void visitFormalTypeParameter(String name) {
            }

            public SignatureVisitor visitClassBound() {
                return super.visitInterfaceBound();
            }

            public SignatureVisitor visitInterfaceBound() {
                return super.visitInterfaceBound();
            }

            public SignatureVisitor visitParameterType() {
                return new AppendType();
            }

            public SignatureVisitor visitReturnType() {
                return new AppendType();
            }

            public SignatureVisitor visitExceptionType() {
                return new AppendType();
            }

            class AppendType
            extends SignatureVisitor {
                StringBuilder sb;
                int l;

                public AppendType() {
                    super(API);
                    this.sb = new StringBuilder();
                    this.l = 0;
                }

                public void visitBaseType(char descriptor) {
                    if (descriptor != 'V') {
                        this.sb.append(descriptor);
                        if (this.l <= 0) {
                            this.flush();
                        }
                    }
                }

                public void visitTypeVariable(String name) {
                    this.sb.append("T");
                    this.sb.append(name);
                    this.sb.append(";");
                    if (this.l <= 0) {
                        this.flush();
                    }
                }

                public SignatureVisitor visitArrayType() {
                    this.sb.append("[");
                    return this;
                }

                public void visitClassType(String name) {
                    ++this.l;
                    this.sb.append("L");
                    this.sb.append(name);
                    this.sb.append("<");
                }

                public void visitInnerClassType(String name) {
                    this.visitClassType(name);
                }

                public void visitTypeArgument() {
                }

                public SignatureVisitor visitTypeArgument(char wildcard) {
                    if (wildcard != '=') {
                        this.sb.append(wildcard);
                    }
                    if (this.l <= 0) {
                        this.flush();
                    }
                    return this;
                }

                public void visitEnd() {
                    --this.l;
                    if (this.sb.charAt(this.sb.length() - 1) == '<') {
                        this.sb.setLength(this.sb.length() - 1);
                    } else {
                        this.sb.append('>');
                    }
                    this.sb.append(";");
                    if (this.l <= 0) {
                        this.flush();
                    }
                }

                private void flush() {
                    if (this.sb.length() > 0) {
                        types.add(this.sb.toString());
                        this.sb = new StringBuilder();
                    }
                }
            }
        });
        return types;
    }

    public static String toSignature(Method exec) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> clazz : exec.getParameterTypes()) {
            sb.append(AsmUtils.toTargetTypeDeclaration(clazz));
        }
        sb.append(")");
        sb.append(AsmUtils.toTargetTypeDeclaration(exec.getReturnType()));
        return sb.toString();
    }

    public static int getLoadOps(Class<?> parameterType) {
        if (TypeHelper.isPrimitive(parameterType)) {
            return loadOps.get(parameterType);
        }
        return 25;
    }

    public static int getStoreOps(Class<?> type) {
        if (TypeHelper.isPrimitive(type)) {
            return storeOps.get(type);
        }
        return 58;
    }

    public static void addIndex(MethodVisitor mv, int i) {
        switch (i) {
            case 0: {
                mv.visitInsn(3);
                return;
            }
            case 1: {
                mv.visitInsn(4);
                return;
            }
            case 2: {
                mv.visitInsn(5);
                return;
            }
            case 3: {
                mv.visitInsn(6);
                return;
            }
            case 4: {
                mv.visitInsn(7);
                return;
            }
            case 5: {
                mv.visitInsn(8);
                return;
            }
        }
        if (i <= 127) {
            mv.visitIntInsn(16, i);
        } else if (i <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, i);
        } else {
            mv.visitLdcInsn((Object)i);
        }
    }

    static {
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Void.TYPE, Void.class);
        primitivesType = new HashMap();
        primitivesType.put(Boolean.TYPE, "Z");
        primitivesType.put(Byte.TYPE, "B");
        primitivesType.put(Character.TYPE, "C");
        primitivesType.put(Double.TYPE, "D");
        primitivesType.put(Float.TYPE, "F");
        primitivesType.put(Integer.TYPE, "I");
        primitivesType.put(Long.TYPE, "J");
        primitivesType.put(Short.TYPE, "S");
        primitivesType.put(Void.TYPE, "V");
        stringToPrimitivesType = new HashMap<String, String>();
        stringToPrimitivesType.put("Boolean", "Z");
        stringToPrimitivesType.put("Byte", "B");
        stringToPrimitivesType.put("Character", "C");
        stringToPrimitivesType.put("Double", "D");
        stringToPrimitivesType.put("Float", "F");
        stringToPrimitivesType.put("Int", "I");
        stringToPrimitivesType.put("Long", "J");
        stringToPrimitivesType.put("Short", "S");
        loadOps = new HashMap();
        loadOps.put(Boolean.TYPE, 21);
        loadOps.put(Byte.TYPE, 21);
        loadOps.put(Character.TYPE, 21);
        loadOps.put(Double.TYPE, 24);
        loadOps.put(Float.TYPE, 23);
        loadOps.put(Integer.TYPE, 21);
        loadOps.put(Long.TYPE, 22);
        loadOps.put(Short.TYPE, 21);
        storeOps = new HashMap();
        storeOps.put(Boolean.TYPE, 54);
        storeOps.put(Byte.TYPE, 54);
        storeOps.put(Character.TYPE, 54);
        storeOps.put(Double.TYPE, 57);
        storeOps.put(Float.TYPE, 56);
        storeOps.put(Integer.TYPE, 54);
        storeOps.put(Long.TYPE, 55);
        storeOps.put(Short.TYPE, 54);
        returnOps = new HashMap();
        returnOps.put(Boolean.TYPE, 172);
        returnOps.put(Byte.TYPE, 172);
        returnOps.put(Character.TYPE, 172);
        returnOps.put(Double.TYPE, 175);
        returnOps.put(Float.TYPE, 174);
        returnOps.put(Integer.TYPE, 172);
        returnOps.put(Long.TYPE, 173);
        returnOps.put(Short.TYPE, 172);
        defaultValue = new HashMap();
        defaultValue.put(Boolean.TYPE, 3);
        defaultValue.put(Byte.TYPE, 3);
        defaultValue.put(Character.TYPE, 3);
        defaultValue.put(Double.TYPE, 14);
        defaultValue.put(Float.TYPE, 11);
        defaultValue.put(Integer.TYPE, 3);
        defaultValue.put(Long.TYPE, 9);
        defaultValue.put(Short.TYPE, 3);
        primitivesClassAndWrapper = new HashSet();
        primitivesClassAndWrapper.addAll(wrappers.keySet());
        primitivesClassAndWrapper.addAll(wrappers.values());
        targetDir = null;
        String targetDirStr = System.getProperty(ASM_DUMP_TARGET_DIR);
        if (targetDirStr != null) {
            targetDir = new File(targetDirStr);
            targetDir.mkdirs();
        }
    }

    private static class TypeCreator
    extends SignatureVisitor {
        final Consumer<Type> consumer;
        final ClassLoader classLoader;
        private final List<String> genericTypeNames;
        private final Type target;
        protected Type type;
        final List<Type> arguments = new ArrayList<Type>();
        boolean flushed = false;

        public TypeCreator(Consumer<Type> consumer, ClassLoader classLoader, List<String> genericTypeNames, Type target) {
            super(API);
            this.consumer = consumer;
            this.classLoader = classLoader;
            this.genericTypeNames = genericTypeNames;
            this.target = target;
        }

        public void visitFormalTypeParameter(String name) {
            super.visitFormalTypeParameter(name);
        }

        public SignatureVisitor visitParameterType() {
            return super.visitParameterType();
        }

        public void visitBaseType(char descriptor) {
            switch (descriptor) {
                case 'Z': {
                    this.type = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    this.type = Byte.TYPE;
                    break;
                }
                case 'C': {
                    this.type = Character.TYPE;
                    break;
                }
                case 'D': {
                    this.type = Double.TYPE;
                    break;
                }
                case 'F': {
                    this.type = Float.TYPE;
                    break;
                }
                case 'I': {
                    this.type = Integer.TYPE;
                    break;
                }
                case 'J': {
                    this.type = Long.TYPE;
                    break;
                }
                case 'S': {
                    this.type = Short.TYPE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected primitiv " + descriptor);
                }
            }
            this.visitEnd();
        }

        public void visitTypeVariable(String name) {
            int i = this.genericTypeNames.indexOf(name);
            if (i >= 0 && this.target instanceof ParameterizedType) {
                Type resolvedType = ((ParameterizedType)this.target).getActualTypeArguments()[i];
                this.consumer.accept((Object)resolvedType);
            }
        }

        public SignatureVisitor visitArrayType() {
            return new TypeCreator(new Consumer<Type>(){

                public void accept(Type type) {
                    consumer.accept(Array.newInstance(TypeHelper.toClass((Type)type), 0).getClass());
                }
            }, this.classLoader, this.genericTypeNames, this.target);
        }

        public void visitClassType(String name) {
            try {
                this.type = Class.forName(name.replace('/', '.'), true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                ErrorHelper.rethrow((Throwable)e);
            }
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return new TypeCreator(new Consumer<Type>(){

                public void accept(Type type) {
                    arguments.add(type);
                }
            }, this.classLoader, this.genericTypeNames, this.target);
        }

        public void visitEnd() {
            if (this.flushed) {
                return;
            }
            this.flushed = true;
            if (this.arguments.isEmpty()) {
                this.consumer.accept((Object)this.type);
            } else {
                this.consumer.accept((Object)new ParameterizedTypeImpl(TypeHelper.toClass((Type)this.type), this.arguments.toArray(EMPTY_TYPE_ARRAY)));
            }
        }
    }

    private static class TypeIsPublicAndImplement
    implements Predicate<Type> {
        private final Class<?> expose;

        public TypeIsPublicAndImplement(Class<?> expose) {
            this.expose = expose;
        }

        public boolean test(Type type) {
            Class targetClass = TypeHelper.toClass((Type)type);
            return Modifier.isPublic(targetClass.getModifiers()) && this.expose.isAssignableFrom(targetClass);
        }
    }

    private static class TypeIsPublicAndHasMethodMethod
    implements Predicate<Type> {
        private final String method;

        public TypeIsPublicAndHasMethodMethod(String method) {
            this.method = method;
        }

        public boolean test(Type type) {
            Class clazz = TypeHelper.toClass((Type)type);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equals(this.method)) continue;
                return true;
            }
            return false;
        }
    }
}

