/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv.parser;

import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellPreProcessor;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class YamlCellPreProcessor
extends CellPreProcessor {
    private static final int COMMENT = 2;
    private static final int REGULAR_ROW = 1;
    private static final int NONE = 0;
    private final boolean ignoreLeadingSpace;

    public YamlCellPreProcessor(boolean ignoreLeadingSpace) {
        this.ignoreLeadingSpace = ignoreLeadingSpace;
    }

    @Override
    public void newCell(char[] chars, int start, int end, CellConsumer cellConsumer, int state) {
        YamlCellConsumer yamlCellConsumer = (YamlCellConsumer)cellConsumer;
        yamlCellConsumer.newCell(chars, start, end, state);
    }

    @Override
    public boolean ignoreLeadingSpace() {
        return this.ignoreLeadingSpace;
    }

    public static CellConsumer commentConsumerToCellConsumer(CheckedConsumer<String> commentConsumer) {
        return commentConsumer != null ? new CommentConsumer(commentConsumer) : null;
    }

    public static final class YamlCellConsumer
    implements CellConsumer {
        private final CellConsumer rowDelegate;
        private final CellConsumer commentDelegate;
        private final CellPreProcessor rowCellPreProcessor;
        private int rowState;

        public YamlCellConsumer(CellConsumer rowDelegate, CellConsumer commentDelegate, CellPreProcessor rowCellPreProcessor) {
            this.rowDelegate = (CellConsumer)Asserts.requireNonNull((String)"rowDelegate", (Object)rowDelegate);
            this.commentDelegate = commentDelegate;
            this.rowCellPreProcessor = rowCellPreProcessor;
        }

        @Override
        public void newCell(char[] chars, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void newCell(char[] chars, int start, int end, int state) {
            if ((state & 0x20) == 0) {
                this.rowCellPreProcessor.newCell(chars, start, end, this.rowDelegate, state);
                this.rowState = 1;
            } else {
                if (this.commentDelegate != null) {
                    this.commentDelegate.newCell(chars, start, end - start);
                }
                this.rowState = 2;
            }
        }

        @Override
        public boolean endOfRow() {
            boolean b = this.rowState != 2 ? this.rowDelegate.endOfRow() : this.commentDelegate != null && this.commentDelegate.endOfRow();
            this.rowState = 0;
            return b;
        }

        @Override
        public void end() {
            this.rowDelegate.end();
            if (this.commentDelegate != null) {
                this.commentDelegate.end();
            }
        }
    }

    public static final class CommentConsumer
    implements CellConsumer {
        private final CheckedConsumer<String> delegate;

        public CommentConsumer(CheckedConsumer<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void newCell(char[] chars, int offset, int length) {
            try {
                this.delegate.accept((Object)new String(chars, offset, length));
            }
            catch (Exception e) {
                ErrorHelper.rethrow((Throwable)e);
            }
        }

        @Override
        public boolean endOfRow() {
            return true;
        }

        @Override
        public void end() {
        }
    }
}

