/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.util.TypeHelper;

public class AsmUtils {
    public static final String ASM_DUMP_TARGET_DIR = "asm.dump.target.dir";
    static File targetDir = null;
    public static final int API;
    static final Map<Class<?>, String> primitivesType;

    public static byte[] writeClassToFile(String className, byte[] bytes) throws IOException {
        return AsmUtils.writeClassToFileInDir(className, bytes, targetDir);
    }

    public static byte[] writeClassToFileInDir(String className, byte[] bytes, File targetDir) throws IOException {
        if (targetDir != null) {
            AsmUtils._writeClassToFileInDir(className, bytes, targetDir);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _writeClassToFileInDir(String className, byte[] bytes, File targetDir) throws IOException {
        int lastIndex = className.lastIndexOf(46);
        String filename = className.substring(lastIndex + 1) + ".class";
        String directory = className.substring(0, lastIndex).replace('.', '/');
        File packageDir = new File(targetDir, directory);
        packageDir.mkdirs();
        try (FileOutputStream fos = new FileOutputStream(new File(packageDir, filename));){
            fos.write(bytes);
        }
    }

    public static String toAsmType(String name) {
        return name.replace('.', '/');
    }

    public static String toAsmType(Type type) {
        if (TypeHelper.isPrimitive((Type)type)) {
            return primitivesType.get(TypeHelper.toClass((Type)type));
        }
        return AsmUtils.toAsmType(TypeHelper.toClass((Type)type).getName());
    }

    public static String toTargetTypeDeclaration(Type targetType) {
        if (TypeHelper.isPrimitive((Type)targetType)) {
            return primitivesType.get(TypeHelper.toClass((Type)targetType));
        }
        return AsmUtils.toTargetTypeDeclaration(AsmUtils.toAsmType(targetType));
    }

    public static String toTargetTypeDeclaration(String targetType) {
        if (targetType.startsWith("[")) {
            return targetType;
        }
        return "L" + targetType + ";";
    }

    public static String toGenericAsmType(Type type) {
        StringBuilder sb = new StringBuilder();
        sb.append(AsmUtils.toAsmType(type));
        Type[] typeParameters = null;
        if (type instanceof ParameterizedType) {
            typeParameters = ((ParameterizedType)type).getActualTypeArguments();
        }
        if (typeParameters != null && typeParameters.length > 0) {
            sb.append("<");
            for (Type t : typeParameters) {
                sb.append(AsmUtils.toTargetTypeDeclaration(AsmUtils.toGenericAsmType(t)));
            }
            sb.append(">");
        }
        return sb.toString();
    }

    static {
        String targetDirStr = System.getProperty(ASM_DUMP_TARGET_DIR);
        if (targetDirStr != null) {
            targetDir = new File(targetDirStr);
            targetDir.mkdirs();
        }
        API = 589824;
        primitivesType = new HashMap();
        primitivesType.put(Boolean.TYPE, "Z");
        primitivesType.put(Byte.TYPE, "B");
        primitivesType.put(Character.TYPE, "C");
        primitivesType.put(Double.TYPE, "D");
        primitivesType.put(Float.TYPE, "F");
        primitivesType.put(Integer.TYPE, "I");
        primitivesType.put(Long.TYPE, "J");
        primitivesType.put(Short.TYPE, "S");
        primitivesType.put(Void.TYPE, "V");
    }
}

