/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.generator;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ImportsManager;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.sharengo.wikitty.generator.EugengoUtils;

public class WikengoCommonGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(WikengoCommonGenerator.class);
    protected ImportsManager imports;

    protected void clearImports() {
        if (this.imports == null) {
            this.imports = new ImportsManager();
        } else {
            this.imports.clearImports();
        }
    }

    protected void addImport(String fqn) {
        if (this.containsClassAndGeneric(fqn)) {
            String[] type = this.getClassAndGeneric(fqn);
            this.imports.addImport(this.checkForDatatype(type[0]));
            this.addImport(this.checkForDatatype(type[1]));
        } else if (this.isArray(fqn)) {
            this.imports.addImport(this.checkForDatatype(fqn.substring(0, fqn.length() - 2)));
        } else if (this.containsComma(fqn)) {
            String[] fqnCommaSeparated;
            for (String str : fqnCommaSeparated = this.splitByComma(fqn)) {
                if (str == null || str.isEmpty()) continue;
                this.addImport(str.trim());
            }
        } else {
            fqn = this.checkForDatatype(fqn);
            this.imports.addImport(fqn);
        }
    }

    private String[] splitByComma(String fqn) {
        return fqn.split(",");
    }

    private boolean containsComma(String fqn) {
        return fqn != null && fqn.indexOf(",") != -1;
    }

    protected void addImport(Class<?> clazz) {
        this.imports.addImport(clazz);
    }

    protected void addImport(ObjectModelClass clazz) {
        if (clazz != null) {
            this.addImport(clazz.getQualifiedName());
        }
    }

    protected String getType(String fqn) {
        String result = this.getType(fqn, false);
        return result;
    }

    protected String getType(String fqn, boolean convert) {
        if ("org.sharengo.wikitty.Wikitty".equals(fqn) || "Wikitty".equals(fqn)) {
            fqn = "String";
        } else if (convert && null != this.getModel().getEnumeration(fqn)) {
            fqn = "String";
        } else if (convert && this.getModel().hasClass(fqn) && EugengoUtils.isBusinessEntity((ObjectModelClassifier)this.getModel().getClass(fqn))) {
            fqn = "String";
        }
        if (this.containsClassAndGeneric(fqn)) {
            String[] type = this.getClassAndGeneric(fqn);
            return this.imports.getType(this.checkForDatatype(type[0])) + "<" + this.getType(type[1], convert) + ">";
        }
        if (this.containsComma(fqn)) {
            String result = "";
            for (String str : this.splitByComma(fqn)) {
                if (str == null || str.isEmpty()) continue;
                if (!result.isEmpty()) {
                    result = result + ", ";
                }
                result = result + str.trim();
            }
            return result;
        }
        return this.imports.getType(this.checkForDatatype(fqn));
    }

    protected boolean isArray(String fqn) {
        return fqn != null && fqn.trim().endsWith("[]");
    }

    protected boolean containsClassAndGeneric(String fqn) {
        return fqn != null && fqn.indexOf("<") != -1;
    }

    protected String[] getClassAndGeneric(String fqn) {
        int idx = fqn.indexOf("<");
        String[] result = new String[]{fqn.substring(0, idx), fqn.substring(idx + 1, fqn.length() - 1)};
        return result;
    }

    protected void generateImports(Writer output, String currentPackage) throws IOException {
        List imports = this.imports.getImports(currentPackage);
        if (!imports.isEmpty()) {
            for (String importLine : imports) {
                output.write("import " + importLine + ";\n");
                output.write("");
            }
            output.write("\n");
            output.write("");
        }
    }

    protected void generateCopyright(Writer output) throws IOException {
        String copyright = EugengoUtils.getCopyright((Model)this.model);
        if (GeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
    }

    protected void generateClazzDocumentation(Writer output, ObjectModelClassifier classifier, String ... defaultDoc) throws IOException {
        this.generateDocumentation(output, (ObjectModelElement)classifier, "", defaultDoc);
    }

    protected void generateDocumentation(Writer output, ObjectModelElement element, String prefix, String ... defaultDoc) throws IOException {
        String doc = null;
        if (GeneratorUtil.hasDocumentation((ObjectModelElement)element)) {
            doc = element.getDocumentation();
        }
        if (doc != null) {
            Pattern p = Pattern.compile("(\n)");
            Matcher m = p.matcher(doc);
            String docOk = m.replaceAll("\n" + prefix + " * ");
            output.write("" + prefix + "/**\n");
            output.write("" + prefix + " * " + docOk + "\n");
            output.write("" + prefix + " */\n");
            output.write("");
        }
    }

    protected void generateOperationHeader(Writer output, ObjectModelOperation op, boolean generateForInterface, String ... additionalExceptions) throws IOException {
        String opVisibility = op.getVisibility();
        if (generateForInterface && !"".equals(opVisibility) && !"public".equals(opVisibility)) {
            return;
        }
        String opName = op.getName();
        output.write("    // Operation \"" + opName + "\"\n");
        output.write("");
        this.generateDocumentation(output, (ObjectModelElement)op, "    ", new String[0]);
        opVisibility = generateForInterface || "package".equals(opVisibility) ? "" : opVisibility + " ";
        String opType = this.computeType(op.getReturnParameter());
        opType = this.getType(opType);
        String opAbstract = "";
        if (!generateForInterface && op.isAbstract()) {
            opAbstract = "abstract ";
        }
        output.write("    " + opVisibility + "" + opAbstract + "" + opType + " " + opName + "(");
        boolean isFirst = true;
        for (ObjectModelParameter opParam : op.getParameters()) {
            String paramName = opParam.getName();
            String paramType = this.computeType(opParam);
            paramType = this.getType(paramType);
            if (!isFirst) {
                output.write(", ");
            }
            isFirst = false;
            output.write("" + paramType + " " + paramName + "");
        }
        output.write(")");
        if (op.getExceptions() != null && !op.getExceptions().isEmpty() || additionalExceptions != null && additionalExceptions.length > 0) {
            output.write(" throws");
            isFirst = true;
            LinkedHashSet<String> exceptions = new LinkedHashSet<String>();
            if (additionalExceptions != null) {
                for (String exception : additionalExceptions) {
                    exceptions.add(exception);
                }
            }
            if (op.getExceptions() != null) {
                for (String exception : op.getExceptions()) {
                    exceptions.add(exception);
                }
            }
            for (String exception : exceptions) {
                exception = this.getType(exception);
                if (!isFirst) {
                    output.write(",");
                }
                isFirst = false;
                output.write(" " + exception + "");
            }
        }
        if (generateForInterface || op.isAbstract()) {
            output.write(";\n");
            output.write("\n");
            output.write("");
        } else {
            output.write(" {\n");
            output.write("");
        }
    }

    protected void generateIocDependency(Writer output, ObjectModelDependency dep) throws IOException {
        ObjectModelClassifier supplier = dep.getSupplier();
        if (supplier == null || EugengoUtils.isDao(supplier)) {
            return;
        }
        String supplierType = this.getType(supplier.getQualifiedName());
        String supplierVarName = EugengoUtils.toLowerCaseFirstLetter((String)supplier.getName());
        String supplierMethodSuffix = EugengoUtils.toUpperCaseFirstLetter((String)supplier.getName());
        output.write("    // Dependency injection for \"" + supplierVarName + "\"\n");
        output.write("    private " + supplierType + " " + supplierVarName + ";\n");
        output.write("\n");
        output.write("    public " + supplierType + " get" + supplierMethodSuffix + "() {\n");
        output.write("        return " + supplierVarName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void set" + supplierMethodSuffix + "(" + supplierType + " " + supplierVarName + ") {\n");
        output.write("        this." + supplierVarName + " = " + supplierVarName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected void generateAttributesDeclaration(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            this.generateAttributeDeclaration(output, attr);
        }
    }

    protected void generateAttributeDeclaration(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType);
        String attrVisibility = attr.getVisibility();
        String attrName = attr.getName();
        output.write("    // Declaration of attribute \"" + attrName + "\"\n");
        output.write("");
        this.generateDocumentation(output, (ObjectModelElement)attr, "    ", new String[0]);
        String value = this.computeDefaultValue(attr);
        output.write("    " + attrVisibility + " " + attrType + " " + attrName + "" + value + ";\n");
        output.write("\n");
        output.write("");
    }

    protected String computeType(ObjectModelParameter param) {
        boolean isCollection;
        if (param == null) {
            return "void";
        }
        String result = param.getType();
        if ("org.sharengo.wikitty.Wikitty".equals(result) || "Wikitty".equals(result)) {
            result = "String";
        }
        boolean bl = isCollection = param.getMaxMultiplicity() != 0 && param.getMaxMultiplicity() != 1;
        if (isCollection) {
            Class<Collection> type = Collection.class;
            if (param.isOrdered()) {
                type = List.class;
            }
            if (param.isUnique()) {
                type = Set.class;
            }
            result = type.getName() + "<" + result + ">";
        }
        return result;
    }

    protected void generateAttributesAccessors(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            this.generateAttributeAccessors(output, attr);
        }
    }

    protected void generateAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("    // Accessors for attribute \"" + attrName + "\"\n");
        output.write("    public void set" + attrNameCapitalized + "(" + attrType + " " + attrName + ") {\n");
        output.write("        this." + attrName + " = " + attrName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
        output.write("        return this." + attrName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected void generateStaticAttributes(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isStatic() || !"public".equals(attr.getVisibility())) continue;
            String type = this.computeType((ObjectModelParameter)attr);
            type = this.getType(type);
            String name = attr.getName();
            String value = this.computeDefaultValue(attr);
            output.write("    // static attribute \"" + name + "\"\n");
            output.write("    public static " + type + " " + name + "" + value + ";\n");
            output.write("\n");
            output.write("");
        }
    }

    protected String computeDefaultValue(ObjectModelAttribute attr) {
        String result = "";
        String value = attr.getDefaultValue();
        if (value != null) {
            String type = this.computeType((ObjectModelParameter)attr);
            if ("String".equals(type = this.getType(type))) {
                result = "\"" + value + "\"";
            } else if ("boolean".equalsIgnoreCase(type)) {
                result = "Boolean." + ("true".equalsIgnoreCase(value) + "").toUpperCase();
            } else if ("byte".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
                result = value;
            } else if ("long".equalsIgnoreCase(type)) {
                result = value + "L";
            } else if ("float".equalsIgnoreCase(type)) {
                result = value + "F";
            } else if ("double".equalsIgnoreCase(type)) {
                result = value + "D";
            } else if ("Date".equals(type)) {
                try {
                    Date d = new SimpleDateFormat().parse(value);
                    result = "new Date(" + d.getTime() + "l)";
                }
                catch (ParseException pe) {
                    log.warn((Object)"Unable to parse date", (Throwable)pe);
                }
            } else {
                result = value;
            }
            result = " = " + result;
        }
        return result;
    }

    protected void generateDefaultConstructor(Writer output, String name) throws IOException {
        output.write("    /**\n");
        output.write("     * Default constructor \n");
        output.write("     */\n");
        output.write("    public " + name + "() {\n");
        output.write("        super();\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected void generateExceptionConstructors(Writer output, ObjectModelClass clazz) throws IOException {
        String name = clazz.getName();
        this.generateDefaultConstructor(output, name);
        output.write("    public " + name + "(Throwable cause) {\n");
        output.write("        super();\n");
        output.write("        initCause(cause);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected void generateFullConstructor(Writer output, String name, Collection<ObjectModelAttribute> attrs) throws IOException {
        int nb = 0;
        int total = 0;
        if (this.hasNavigableAndNonStaticAttributes(attrs)) {
            String attrName;
            output.write("    /**\n");
            output.write("     * Constructor with all parameters initialized\n");
            output.write("     * \n");
            output.write("");
            for (ObjectModelAttribute attr : attrs) {
                if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
                ++total;
                String attName = attr.getName();
                output.write("     * @param " + attName + "\n");
                output.write("");
            }
            output.write("     */\n");
            output.write("    public " + name + "(");
            for (ObjectModelAttribute attr : attrs) {
                if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
                attrName = attr.getName();
                String attrType = this.getType(this.computeType((ObjectModelParameter)attr));
                if (!EugengoUtils.notEmpty((String)attrType)) {
                    return;
                }
                attrType = this.getType(attrType);
                output.write("" + attrType + " " + attrName + "");
                if (++nb >= total) continue;
                output.write(", ");
            }
            output.write(") {\n");
            output.write("        super();\n");
            output.write("");
            for (ObjectModelAttribute attr : attrs) {
                if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
                attrName = attr.getName();
                output.write("        this." + attrName + " = " + attrName + ";\n");
                output.write("");
            }
            output.write("    } \n");
            output.write("\n");
            output.write("");
        }
    }

    protected boolean hasNavigableAndNonStaticAttributes(ObjectModelClass clazz) {
        return this.hasNavigableAndNonStaticAttributes(clazz.getAttributes());
    }

    protected boolean hasNavigableAndNonStaticAttributes(Collection<ObjectModelAttribute> attrs) {
        if (attrs != null && !attrs.isEmpty()) {
            for (ObjectModelAttribute attr : attrs) {
                if (!attr.isNavigable() || attr.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    protected void lookForAttributeImports(ObjectModelClass clazz) {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            String type = this.computeType((ObjectModelParameter)attr);
            this.addImport(type);
        }
    }

    protected void lookForStaticAttributeImports(ObjectModelClass clazz) {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || !attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            String type = this.computeType((ObjectModelParameter)attr);
            this.addImport(type);
        }
    }

    protected void lookForOperationImports(ObjectModelClassifier classifier) {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String returnType = this.computeType(op.getReturnParameter());
            this.addImport(returnType);
            for (ObjectModelParameter param : op.getParameters()) {
                String paramType = this.computeType(param);
                this.addImport(paramType);
            }
            for (String exceptionType : op.getExceptions()) {
                this.addImport(exceptionType);
            }
        }
    }

    protected void lookForIocImports(ObjectModelClassifier classifier) {
        for (ObjectModelDependency dep : classifier.getDependencies()) {
            ObjectModelClassifier supplier = dep.getSupplier();
            if (supplier == null || !EugengoUtils.isService(supplier)) continue;
            this.addImport(supplier.getQualifiedName());
        }
    }

    protected String checkForDatatype(String type) {
        if (type != null) {
            String tag = this.model.getTagValue("dataType-" + type);
            if (tag != null) {
                return tag;
            }
            int idx = type.indexOf("<");
            if (idx != -1) {
                tag = this.model.getTagValue("dataType-" + type.substring(0, idx));
            }
            if (tag != null) {
                return tag;
            }
        }
        return type;
    }

    protected ObjectModelClass findSuperClass(ObjectModelClass clazz) {
        if (clazz.getSuperclasses() != null && !clazz.getSuperclasses().isEmpty()) {
            return (ObjectModelClass)clazz.getSuperclasses().iterator().next();
        }
        return null;
    }

    protected Collection<ObjectModelClass> findSubClasses(ObjectModelClass clazz) {
        ArrayList<ObjectModelClass> result = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass potentialSubClass : this.model.getClasses()) {
            if (!clazz.equals(this.findSuperClass(potentialSubClass))) continue;
            result.add(potentialSubClass);
        }
        return result;
    }

    protected void generateHashCode(Writer output, ObjectModelClass clazz) throws IOException {
        output.write("    public int hashCode() {\n");
        output.write("        int result = 0;\n");
        output.write("");
        String prefix = "";
        if (EugengoUtils.isEntity((ObjectModelClassifier)clazz)) {
            output.write("        if (id != null) {\n");
            output.write("            result = id.hashCode();\n");
            output.write("        } else {\n");
            output.write("");
            prefix = "    ";
        }
        this.generateHashCodeFromAttributes(output, clazz, prefix);
        if (EugengoUtils.isEntity((ObjectModelClassifier)clazz)) {
            output.write("        }\n");
            output.write("");
        }
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    private void generateHashCodeFromAttributes(Writer output, ObjectModelClass clazz, String prefix) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            String attrName = attr.getName();
            String attrType = this.getType(attr.getType());
            if (EugengoUtils.isPrimitiveType(attr)) {
                if (attrType.charAt(0) == attrType.toUpperCase().charAt(0)) {
                    output.write("" + prefix + "        if (" + attrName + " != null) {\n");
                    output.write("" + prefix + "            result = 29 * result + " + attrName + ".hashCode();\n");
                    output.write("" + prefix + "        }\n");
                    output.write("");
                    continue;
                }
                if ("Int".equals(attrType = EugengoUtils.toUpperCaseFirstLetter((String)attrType))) {
                    attrType = "Integer";
                }
                output.write("" + prefix + "        result = 29 * result + new " + attrType + "(" + attrName + ").hashCode();\n");
                output.write("");
                continue;
            }
            output.write("" + prefix + "        if (" + attrName + " != null) {\n");
            output.write("" + prefix + "            result = 29 * result + " + attrName + ".hashCode();\n");
            output.write("" + prefix + "        }\n");
            output.write("");
        }
    }
}

