/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty;

import java.util.Collection;
import java.util.List;

/**
 *
 * @author poussin
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public interface WikittyExtensionStorage {

    /**
     * Store extension in storage.
     * 
     * @param transaction the current transaction
     * @param extensions the extensions to store
     * @return information usefull for client side update data
     */
    UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions);

    /**
     * Return true if id exists in storage.
     * 
     * @param transaction the current transaction
     * @param id an extension id
     * @return true if the extension exists
     */
    boolean exists(WikittyTransaction transaction, String id);

    /**
     * Return all extension ids.
     * 
     * @param transaction the current transaction
     * @return a list of extension ids
     */
    List<String> getAllExtensionIds(WikittyTransaction transaction);

    /**
     * Return all extension ids where the specified extensionName is required.
     * 
     * @param transaction the current transaction
     * @param extensionName the extension required
     * @return a list of extension ids
     */
    List<String> getAllExtensionsRequires(WikittyTransaction transaction,
            String extensionName);
    
    /**
     * return last version available for specified extension name.
     * 
     * @param transaction the current transaction
     * @param extName name of extension
     * @return last version availble for this version, or null if extension
     * doesn't exist
     */
    String getLastVersion(WikittyTransaction transaction, String extName);

    /**
     * Restore one extension from storage, if not found an exception is thrown.
     * 
     * @param transaction the current transaction
     * @param name extension name to restore
     * @param version extension version to restore
     * @return an extension
     */
    WikittyExtension restore(WikittyTransaction transaction, String name, String version)
            throws WikittyException;

    /**
     * Remove all extensions
     */
    public void clear(WikittyTransaction transaction);
    
}
