/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class FindElements
extends WebDriverHandler<Set<Map<String, String>>>
implements JsonParametersAware {
    private volatile By by;

    public FindElements(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.by = this.newBySelector().pickFromJsonParameters(allParameters);
    }

    @Override
    public Set<Map<String, String>> call() throws Exception {
        List elements = this.getDriver().findElements(this.by);
        return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)elements, (Function)new Function<WebElement, Map<String, String>>(){

            public Map<String, String> apply(WebElement element) {
                return ImmutableMap.of((Object)"ELEMENT", (Object)FindElements.this.getKnownElements().add(element));
            }
        }));
    }

    public String toString() {
        return String.format("[find elements: %s]", this.by);
    }
}

