/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class GetAllSessions
implements RestishHandler {
    private final Response response = new Response();
    private volatile DriverSessions allSessions;

    public GetAllSessions(DriverSessions allSession) {
        this.allSessions = allSession;
    }

    @Override
    public ResultType handle() throws Exception {
        Set<SessionId> sessions = this.allSessions.getSessions();
        Iterable sessionInfo = Iterables.transform(sessions, this.toSessionInfo());
        this.response.setValue((Object)ImmutableList.copyOf((Iterable)sessionInfo));
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    private Function<SessionId, SessionInfo> toSessionInfo() {
        return new Function<SessionId, SessionInfo>(){

            public SessionInfo apply(SessionId id) {
                Map capabilities = GetAllSessions.this.allSessions.get(id).getCapabilities().asMap();
                return new SessionInfo(id, capabilities);
            }
        };
    }

    private static class SessionInfo {
        private final SessionId id;
        private final Map<String, ?> capabilities;

        public SessionInfo(SessionId id, Map<String, ?> capabilities) {
            this.id = id;
            this.capabilities = capabilities;
        }

        public String getId() {
            return this.id.toString();
        }

        public Map<String, ?> getCapabilities() {
            return this.capabilities;
        }
    }
}

