/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Platform;

public class ExecutableFinder {
    private static final List<String> ENDINGS = Platform.getCurrent().is(Platform.WINDOWS) ? List.of("", ".cmd", ".exe", ".com", ".bat") : Collections.singletonList("");

    public @Nullable String find(String named) {
        File file = new File(named);
        if (ExecutableFinder.canExecute(file)) {
            return named;
        }
        if (Platform.getCurrent().is(Platform.WINDOWS) && ExecutableFinder.canExecute(file = new File(named + ".exe"))) {
            return named + ".exe";
        }
        ArrayList<String> pathSegments = new ArrayList<String>(this.fromEnvironment());
        if (Platform.getCurrent().is(Platform.MAC)) {
            pathSegments.addAll(this.macSpecificPathSegments());
        }
        for (String pathSegment : pathSegments) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, named + ending);
                if (!ExecutableFinder.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private List<String> fromEnvironment() {
        String path;
        String pathName = "PATH";
        Map<String, String> env = System.getenv();
        if (!env.containsKey(pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        return (path = env.get(pathName)) != null ? List.of(path.split(File.pathSeparator)) : Collections.emptyList();
    }

    private List<String> macSpecificPathSegments() {
        File pathFile = new File("/etc/paths");
        if (pathFile.exists()) {
            try {
                return Files.readAllLines(pathFile.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static boolean canExecute(File file) {
        return file.exists() && !file.isDirectory() && file.canExecute();
    }
}

