/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_EXE_PROPERTY = "webdriver.ie.driver";
    public static final String IE_DRIVER_LOGFILE_PROPERTY = "webdriver.ie.driver.logfile";
    public static final String IE_DRIVER_LOGLEVEL_PROPERTY = "webdriver.ie.driver.loglevel";
    public static final String IE_DRIVER_HOST_PROPERTY = "webdriver.ie.driver.host";
    public static final String IE_DRIVER_EXTRACT_PATH_PROPERTY = "webdriver.ie.driver.extractpath";
    public static final String IE_DRIVER_SILENT_PROPERTY = "webdriver.ie.driver.silent";

    private InternetExplorerDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static InternetExplorerDriverService createDefaultService() {
        return new Builder().usingAnyFreePort().build();
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;
        private InternetExplorerDriverLogLevel logLevel;
        private String host = null;
        private File extractPath = null;
        private Boolean silent = null;
        private Boolean forceCreateProcess = null;
        private String ieSwitches = null;

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            InternetExplorerDriverService.checkExecutable((File)file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withLogLevel(InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withExtractPath(File extractPath) {
            this.extractPath = extractPath;
            return this;
        }

        public Builder withSilent(Boolean silent) {
            this.silent = silent;
            return this;
        }

        public InternetExplorerDriverService build() {
            String silentProperty;
            String extractPathProperty;
            String hostProperty;
            String level;
            String logFilePath;
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = InternetExplorerDriverService.findExecutable((String)"IEDriverServer", (String)InternetExplorerDriverService.IE_DRIVER_EXE_PROPERTY, (String)"http://code.google.com/p/selenium/wiki/InternetExplorerDriver", (String)"http://selenium-release.storage.googleapis.com/index.html");
            }
            if (this.logFile == null && (logFilePath = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGFILE_PROPERTY)) != null) {
                this.logFile = new File(logFilePath);
            }
            if (this.logLevel == null && (level = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGLEVEL_PROPERTY)) != null) {
                this.logLevel = InternetExplorerDriverLogLevel.valueOf(level);
            }
            if (this.host == null && (hostProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_HOST_PROPERTY)) != null) {
                this.host = hostProperty;
            }
            if (this.extractPath == null && (extractPathProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_EXTRACT_PATH_PROPERTY)) != null) {
                this.extractPath = new File(extractPathProperty);
            }
            if (this.silent == null && (silentProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_SILENT_PROPERTY)) != null) {
                this.silent = Boolean.valueOf(silentProperty);
            }
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add((Object)String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add((Object)String.format("--log-file=\"%s\"", this.logFile.getAbsolutePath()));
                }
                if (this.logLevel != null) {
                    argsBuilder.add((Object)String.format("--log-level=%s", this.logLevel.toString()));
                }
                if (this.host != null) {
                    argsBuilder.add((Object)String.format("--host=%s", this.host));
                }
                if (this.extractPath != null) {
                    argsBuilder.add((Object)String.format("--extract-path=\"%s\"", this.extractPath.getAbsolutePath()));
                }
                if (this.silent != null && this.silent.equals(Boolean.TRUE)) {
                    argsBuilder.add((Object)"--silent");
                }
                return new InternetExplorerDriverService(this.exe, this.port, argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

