/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;

class StringWrapper {
    private final String value;

    public StringWrapper(ExportedWebDriverFunctions lib, PointerByReference ptr) {
        this.value = this.extractString(lib, ptr.getValue());
    }

    private String extractString(ExportedWebDriverFunctions lib, Pointer string) {
        IntByReference length = new IntByReference();
        if (lib.wdStringLength(string, length) != 0) {
            lib.wdFreeString(string);
            throw new RuntimeException("Cannot determine length of string");
        }
        char[] rawString = new char[length.getValue()];
        if (lib.wdCopyString(string, length.getValue(), rawString) != 0) {
            lib.wdFreeString(string);
            throw new RuntimeException("Cannot copy string from native data to Java string");
        }
        String value = Native.toString((char[])rawString);
        lib.wdFreeString(string);
        return value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return null;
    }
}

