/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Version;
import org.openqa.selenium.docker.client.DockerClient;
import org.openqa.selenium.internal.Maps;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class VersionCommand {
    private static final Json JSON = new Json();
    private static final Map<Version, Function<HttpHandler, DockerProtocol>> SUPPORTED_VERSIONS = Maps.sequencedMapOf((Object)new Version("1.48"), client -> new DockerClient((HttpHandler)client, "1.48"), (Object)new Version("1.44"), client -> new DockerClient((HttpHandler)client, "1.44"), (Object)new Version("1.40"), client -> new DockerClient((HttpHandler)client, "1.40"));
    private final HttpHandler handler;

    public VersionCommand(HttpHandler handler) {
        this.handler = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)handler);
    }

    public Optional<DockerProtocol> getDockerProtocol(String requestedVersion) {
        if (requestedVersion == null || requestedVersion.isEmpty()) {
            return this.getDockerProtocol();
        }
        Version version = new Version(requestedVersion);
        Function<HttpHandler, DockerProtocol> factory = SUPPORTED_VERSIONS.get(version);
        if (factory != null) {
            return Optional.of(factory.apply(this.handler));
        }
        return SUPPORTED_VERSIONS.entrySet().stream().filter(entry -> ((Version)entry.getKey()).equalTo(version)).map(Map.Entry::getValue).map(func -> (DockerProtocol)func.apply(this.handler)).findFirst();
    }

    public Optional<DockerProtocol> getDockerProtocol() {
        try {
            HttpResponse res = this.handler.execute(new HttpRequest(HttpMethod.GET, "/version"));
            if (!res.isSuccessful()) {
                return Optional.empty();
            }
            Map raw = (Map)JSON.toType(res.contentAsString(), Json.MAP_TYPE);
            Version maxVersion = new Version((String)raw.get("ApiVersion"));
            Version minVersion = new Version((String)raw.get("MinAPIVersion"));
            return SUPPORTED_VERSIONS.entrySet().stream().filter(entry -> {
                Version version = (Version)entry.getKey();
                if (version.equalTo(maxVersion) || version.equalTo(minVersion)) {
                    return true;
                }
                return version.isLessThan(maxVersion) && version.isGreaterThan(minVersion);
            }).map(Map.Entry::getValue).map(func -> (DockerProtocol)func.apply(this.handler)).findFirst();
        }
        catch (UncheckedIOException | ClassCastException | NullPointerException | JsonException e) {
            return Optional.empty();
        }
    }
}

