/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Beta;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogLevelMapping;

@Beta
public class SessionLogs {
    private final Map<String, LogEntries> logTypeToEntriesMap = new HashMap<String, LogEntries>();

    public LogEntries getLogs(String logType) {
        if (logType == null || !this.logTypeToEntriesMap.containsKey(logType)) {
            return new LogEntries(Collections.<LogEntry>emptyList());
        }
        return this.logTypeToEntriesMap.get(logType);
    }

    public void addLog(String logType, LogEntries logEntries) {
        this.logTypeToEntriesMap.put(logType, logEntries);
    }

    public Set<String> getLogTypes() {
        return this.logTypeToEntriesMap.keySet();
    }

    public Map<String, LogEntries> getAll() {
        return Collections.unmodifiableMap(this.logTypeToEntriesMap);
    }

    public static SessionLogs fromJSON(JSONObject rawSessionLogs) throws JSONException {
        SessionLogs sessionLogs = new SessionLogs();
        Iterator logTypeItr = rawSessionLogs.keys();
        while (logTypeItr.hasNext()) {
            String logType = (String)logTypeItr.next();
            JSONArray rawLogEntries = rawSessionLogs.getJSONArray(logType);
            ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
            for (int index = 0; index < rawLogEntries.length(); ++index) {
                JSONObject rawEntry = rawLogEntries.getJSONObject(index);
                logEntries.add(new LogEntry(LogLevelMapping.toLevel(rawEntry.getString("level")), rawEntry.getLong("timestamp"), rawEntry.getString("message")));
            }
            sessionLogs.addLog(logType, new LogEntries(logEntries));
        }
        return sessionLogs;
    }
}

