/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.locks;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.helpers.Utils;
import scala.actors.threadpool.locks.Condition;
import scala.actors.threadpool.locks.Lock;

class CondVar
implements Condition,
Serializable {
    private static final long serialVersionUID = -5009898475638427940L;
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptibly() {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean wasInterrupted = Thread.interrupted();
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    wasInterrupted = true;
                }
            }
        }
        finally {
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    if (nanos > 0L) {
                        long start = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        success = Utils.nanoTime() - start < nanos;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i = holdCount; i > 0; --i) {
                    this.lock.unlock();
                }
                try {
                    long start = System.currentTimeMillis();
                    long msecs = abstime - start;
                    if (msecs > 0L) {
                        this.wait(msecs);
                        success = System.currentTimeMillis() - start < msecs;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
        }
        return success;
    }

    @Override
    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    @Override
    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

