/**
 * 
 */
package org.richfaces.event.extdt;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;

/**
 * @author pawelgo
 *
 */
public class DragDropEvent extends FacesEvent {
	
	private static final long serialVersionUID = 2589493255876683993L;
	
	private Object dragValue;
	private Object dropValue;
	private String dragType;
	private boolean dropBefore;

	public DragDropEvent(UIComponent component) {
		super(component);
	}

	public void processListener(FacesListener listener) {
		((DragDropListener)listener).processDragDrop(this);
	}

	public Object getDragValue() {
		return dragValue;
	}

	public void setDragValue(Object dragValue) {
		this.dragValue = dragValue;
	}

	public Object getDropValue() {
		return dropValue;
	}

	public void setDropValue(Object dropValue) {
		this.dropValue = dropValue;
	}
	
	public String getDragType() {
		return dragType;
	}
	
	public void setDragType(String dragType) {
		this.dragType = dragType;
	}
	
	public boolean isDropBefore() {
		return dropBefore;
	}

	public void setDropBefore(boolean dropBefore) {
		this.dropBefore = dropBefore;
	}

	public boolean isAppropriateListener(FacesListener listener) {
		return (listener instanceof DragDropListener);
	}

}
