/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.knownexploited.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.owasp.dependencycheck.data.knownexploited.json.Vulnerability;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"catalogVersion", "dateReleased", "count", "vulnerabilities"})
public class KnownExploitedVulnerabilitiesSchema {
    @JsonProperty(value="catalogVersion")
    @JsonPropertyDescription(value="Version of the known exploited vulnerabilities catalog")
    private String catalogVersion;
    @JsonProperty(value="dateReleased")
    @JsonPropertyDescription(value="Date-time of Catalog Release in the format YYYY-MM-DDTHH:mm:ss.sssZ")
    private Date dateReleased;
    @JsonProperty(value="count")
    @JsonPropertyDescription(value="Total number of Known Exploited Vulnerabilities in the catalog")
    private Integer count;
    @JsonProperty(value="vulnerabilities")
    @JsonPropertyDescription(value="The exploited vulnerabilities included in this catalog")
    private List<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="catalogVersion")
    public String getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonProperty(value="catalogVersion")
    public void setCatalogVersion(String catalogVersion) {
        this.catalogVersion = catalogVersion;
    }

    @JsonProperty(value="dateReleased")
    public Date getDateReleased() {
        return this.dateReleased;
    }

    @JsonProperty(value="dateReleased")
    public void setDateReleased(Date dateReleased) {
        this.dateReleased = dateReleased;
    }

    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    public void setCount(Integer count) {
        this.count = count;
    }

    @JsonProperty(value="vulnerabilities")
    public List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @JsonProperty(value="vulnerabilities")
    public void setVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KnownExploitedVulnerabilitiesSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("catalogVersion");
        sb.append('=');
        sb.append(this.catalogVersion == null ? "<null>" : this.catalogVersion);
        sb.append(',');
        sb.append("dateReleased");
        sb.append('=');
        sb.append(this.dateReleased == null ? "<null>" : this.dateReleased);
        sb.append(',');
        sb.append("count");
        sb.append('=');
        sb.append(this.count == null ? "<null>" : this.count);
        sb.append(',');
        sb.append("vulnerabilities");
        sb.append('=');
        sb.append(this.vulnerabilities == null ? "<null>" : this.vulnerabilities);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.catalogVersion == null ? 0 : this.catalogVersion.hashCode());
        result = result * 31 + (this.count == null ? 0 : this.count.hashCode());
        result = result * 31 + (this.vulnerabilities == null ? 0 : this.vulnerabilities.hashCode());
        result = result * 31 + (this.dateReleased == null ? 0 : this.dateReleased.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KnownExploitedVulnerabilitiesSchema)) {
            return false;
        }
        KnownExploitedVulnerabilitiesSchema rhs = (KnownExploitedVulnerabilitiesSchema)other;
        return (this.catalogVersion == rhs.catalogVersion || this.catalogVersion != null && this.catalogVersion.equals(rhs.catalogVersion)) && (this.count == rhs.count || this.count != null && this.count.equals(rhs.count)) && (this.vulnerabilities == rhs.vulnerabilities || this.vulnerabilities != null && this.vulnerabilities.equals(rhs.vulnerabilities)) && (this.dateReleased == rhs.dateReleased || this.dateReleased != null && this.dateReleased.equals(rhs.dateReleased)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

