/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.data.nexus.NexusV2Search;
import org.owasp.dependencycheck.data.nexus.NexusV3Search;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NexusAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEFAULT_URL = "https://repository.sonatype.org/service/local/";
    private static final Logger LOGGER = LoggerFactory.getLogger(NexusAnalyzer.class);
    private static final String ANALYZER_NAME = "Nexus Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();
    private NexusSearch searcher;
    private boolean enabled = true;

    @Override
    public void initialize(Settings settings) {
        super.initialize(settings);
        this.enabled = this.checkEnabled();
    }

    private boolean checkEnabled() {
        boolean retval = false;
        try {
            if (this.getSettings().getBoolean("analyzer.nexus.enabled")) {
                if (this.getSettings().getString("analyzer.nexus.url") != null && !DEFAULT_URL.equals(this.getSettings().getString("analyzer.nexus.url"))) {
                    retval = true;
                } else {
                    LOGGER.warn("Disabling Nexus analyzer - please specify the URL to a Nexus Server");
                }
            }
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling Nexus analyzer");
        }
        return retval;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing Nexus Analyzer");
        LOGGER.debug("Nexus Analyzer enabled: {}", (Object)this.isEnabled());
        if (this.isEnabled()) {
            boolean useProxy = this.useProxy();
            LOGGER.debug("Using proxy: {}", (Object)useProxy);
            this.searcher = this.createNexusSearchOrDisable(useProxy);
        }
    }

    private NexusSearch createNexusSearchOrDisable(boolean useProxy) throws InitializationException {
        NexusSearch result;
        Settings settings = this.getSettings();
        String nexusRootURL = settings.getString("analyzer.nexus.url");
        try {
            result = nexusRootURL.toLowerCase(Locale.ROOT).contains("service/local/") ? new NexusV2Search(settings, useProxy) : new NexusV3Search(settings, useProxy);
            if (!result.preflightRequest()) {
                this.setEnabled(false);
                throw new InitializationException("There was an error getting Nexus status. Disabling NexusAnalyzer.");
            }
        }
        catch (MalformedURLException mue) {
            this.setEnabled(false);
            throw new InitializationException("Malformed URL to Nexus. Disabling NexusAnalyzer", mue);
        }
        return result;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nexus.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        block16: {
            if (!this.isEnabled()) {
                return;
            }
            try {
                MavenArtifact ma = this.searcher.searchSha1(dependency.getSha1sum());
                dependency.addAsEvidence("nexus", ma, Confidence.HIGH);
                boolean pomAnalyzed = false;
                LOGGER.debug("POM URL {}", (Object)ma.getPomUrl());
                for (Evidence e : dependency.getEvidence(EvidenceType.VENDOR)) {
                    if (!"pom".equals(e.getSource())) continue;
                    pomAnalyzed = true;
                    break;
                }
                if (pomAnalyzed || ma.getPomUrl() == null) break block16;
                File pomFile = null;
                try {
                    File baseDir = this.getSettings().getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        LOGGER.warn("Unable to fetch pom.xml for {} from Nexus repository; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                        LOGGER.debug("Unable to delete temp file");
                    }
                    LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
                    Downloader downloader = new Downloader(this.getSettings());
                    downloader.fetchFile(new URL(ma.getPomUrl()), pomFile);
                    PomUtils.analyzePOM(dependency, pomFile);
                }
                catch (DownloadFailedException ex) {
                    LOGGER.warn("Unable to download pom.xml for {} from Nexus repository; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                catch (TooManyRequestsException ex) {
                    this.setEnabled(false);
                    throw new AnalysisException("Received a 429 - too many requests from nexus; the nexus analyzer is being disabled.", ex);
                }
                catch (ResourceNotFoundException ex) {
                    LOGGER.warn("pom.xml not found for {} from nexus; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                finally {
                    if (pomFile != null && pomFile.exists() && !FileUtils.delete((File)pomFile)) {
                        LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile);
                        pomFile.deleteOnExit();
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOGGER.info("invalid sha-1 hash on {}", (Object)dependency.getFileName());
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.debug("Artifact not found in repository '{}'", (Object)dependency.getFileName());
                LOGGER.debug(fnfe.getMessage(), (Throwable)fnfe);
            }
            catch (IOException ioe) {
                LOGGER.debug("Could not connect to nexus repository", (Throwable)ioe);
            }
        }
    }

    public boolean useProxy() {
        try {
            return this.getSettings().getString("proxy.server") != null && this.getSettings().getBoolean("analyzer.nexus.proxy");
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Failed to parse proxy settings.", (Throwable)ise);
            return false;
        }
    }
}

