/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.knownexploited.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"cveID", "vendorProject", "product", "vulnerabilityName", "dateAdded", "shortDescription", "requiredAction", "dueDate", "notes"})
public class Vulnerability {
    @JsonProperty(value="cveID")
    @JsonPropertyDescription(value="The CVE ID of the vulnerability in the format CVE-YYYY-NNNN, note that the number portion can have more than 4 digits")
    private String cveID;
    @JsonProperty(value="vendorProject")
    @JsonPropertyDescription(value="The vendor or project name for the vulnerability")
    private String vendorProject;
    @JsonProperty(value="product")
    @JsonPropertyDescription(value="The vulnerability product")
    private String product;
    @JsonProperty(value="vulnerabilityName")
    @JsonPropertyDescription(value="The name of the vulnerability")
    private String vulnerabilityName;
    @JsonProperty(value="dateAdded")
    @JsonPropertyDescription(value="The date the vulnerability was added to the catalog in the format YYYY-MM-DD")
    private String dateAdded;
    @JsonProperty(value="shortDescription")
    @JsonPropertyDescription(value="A short description of the vulnerability")
    private String shortDescription;
    @JsonProperty(value="requiredAction")
    @JsonPropertyDescription(value="The required action to address the vulnerability")
    private String requiredAction;
    @JsonProperty(value="dueDate")
    @JsonPropertyDescription(value="The date the required action is due in the format YYYY-MM-DD")
    private String dueDate;
    @JsonProperty(value="notes")
    @JsonPropertyDescription(value="Any additional notes about the vulnerability")
    private String notes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="cveID")
    public String getCveID() {
        return this.cveID;
    }

    @JsonProperty(value="cveID")
    public void setCveID(String cveID) {
        this.cveID = cveID;
    }

    @JsonProperty(value="vendorProject")
    public String getVendorProject() {
        return this.vendorProject;
    }

    @JsonProperty(value="vendorProject")
    public void setVendorProject(String vendorProject) {
        this.vendorProject = vendorProject;
    }

    @JsonProperty(value="product")
    public String getProduct() {
        return this.product;
    }

    @JsonProperty(value="product")
    public void setProduct(String product) {
        this.product = product;
    }

    @JsonProperty(value="vulnerabilityName")
    public String getVulnerabilityName() {
        return this.vulnerabilityName;
    }

    @JsonProperty(value="vulnerabilityName")
    public void setVulnerabilityName(String vulnerabilityName) {
        this.vulnerabilityName = vulnerabilityName;
    }

    @JsonProperty(value="dateAdded")
    public String getDateAdded() {
        return this.dateAdded;
    }

    @JsonProperty(value="dateAdded")
    public void setDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
    }

    @JsonProperty(value="shortDescription")
    public String getShortDescription() {
        return this.shortDescription;
    }

    @JsonProperty(value="shortDescription")
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @JsonProperty(value="requiredAction")
    public String getRequiredAction() {
        return this.requiredAction;
    }

    @JsonProperty(value="requiredAction")
    public void setRequiredAction(String requiredAction) {
        this.requiredAction = requiredAction;
    }

    @JsonProperty(value="dueDate")
    public String getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Vulnerability.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("cveID");
        sb.append('=');
        sb.append(this.cveID == null ? "<null>" : this.cveID);
        sb.append(',');
        sb.append("vendorProject");
        sb.append('=');
        sb.append(this.vendorProject == null ? "<null>" : this.vendorProject);
        sb.append(',');
        sb.append("product");
        sb.append('=');
        sb.append(this.product == null ? "<null>" : this.product);
        sb.append(',');
        sb.append("vulnerabilityName");
        sb.append('=');
        sb.append(this.vulnerabilityName == null ? "<null>" : this.vulnerabilityName);
        sb.append(',');
        sb.append("dateAdded");
        sb.append('=');
        sb.append(this.dateAdded == null ? "<null>" : this.dateAdded);
        sb.append(',');
        sb.append("shortDescription");
        sb.append('=');
        sb.append(this.shortDescription == null ? "<null>" : this.shortDescription);
        sb.append(',');
        sb.append("requiredAction");
        sb.append('=');
        sb.append(this.requiredAction == null ? "<null>" : this.requiredAction);
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(this.dueDate == null ? "<null>" : this.dueDate);
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(this.notes == null ? "<null>" : this.notes);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.product == null ? 0 : this.product.hashCode());
        result = result * 31 + (this.vulnerabilityName == null ? 0 : this.vulnerabilityName.hashCode());
        result = result * 31 + (this.notes == null ? 0 : this.notes.hashCode());
        result = result * 31 + (this.cveID == null ? 0 : this.cveID.hashCode());
        result = result * 31 + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        result = result * 31 + (this.vendorProject == null ? 0 : this.vendorProject.hashCode());
        result = result * 31 + (this.shortDescription == null ? 0 : this.shortDescription.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.requiredAction == null ? 0 : this.requiredAction.hashCode());
        result = result * 31 + (this.dateAdded == null ? 0 : this.dateAdded.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Vulnerability)) {
            return false;
        }
        Vulnerability rhs = (Vulnerability)other;
        return (this.product == rhs.product || this.product != null && this.product.equals(rhs.product)) && (this.vulnerabilityName == rhs.vulnerabilityName || this.vulnerabilityName != null && this.vulnerabilityName.equals(rhs.vulnerabilityName)) && (this.notes == rhs.notes || this.notes != null && this.notes.equals(rhs.notes)) && (this.cveID == rhs.cveID || this.cveID != null && this.cveID.equals(rhs.cveID)) && (this.dueDate == rhs.dueDate || this.dueDate != null && this.dueDate.equals(rhs.dueDate)) && (this.vendorProject == rhs.vendorProject || this.vendorProject != null && this.vendorProject.equals(rhs.vendorProject)) && (this.shortDescription == rhs.shortDescription || this.shortDescription != null && this.shortDescription.equals(rhs.shortDescription)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.requiredAction == rhs.requiredAction || this.requiredAction != null && this.requiredAction.equals(rhs.requiredAction)) && (this.dateAdded == rhs.dateAdded || this.dateAdded != null && this.dateAdded.equals(rhs.dateAdded));
    }
}

