/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.ops4j.pax.exam.rbc.internal.TimeoutException;
import org.ops4j.pax.exam.spi.container.TestContainer;
import org.ops4j.pax.exam.spi.container.TestContainerException;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBundleContextClient
implements TestContainer {
    private static final Log LOG = LogFactory.getLog(RemoteBundleContextClient.class);
    private final Integer m_rmiPort;
    private final long m_rmiLookupTimeout;
    private RemoteBundleContext m_remoteBundleContext;

    public RemoteBundleContextClient(Integer rmiPort, long rmiLookupTimeout) {
        this.m_rmiPort = rmiPort;
        this.m_rmiLookupTimeout = rmiLookupTimeout;
    }

    public <T> T getService(Class<T> serviceType) {
        return this.getService(serviceType, 0L);
    }

    public <T> T getService(Class<T> serviceType, final long timeoutInMillis) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceType}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
                try {
                    return RemoteBundleContextClient.this.getRemoteBundleContext().remoteCall(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), timeoutInMillis, params);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                catch (RemoteException e) {
                    throw new TestContainerException("Remote exception", (Throwable)e);
                }
                catch (Exception e) {
                    throw new TestContainerException("Invocation exception", (Throwable)e);
                }
            }
        });
    }

    public long installBundle(String bundleUrl) {
        try {
            return this.getRemoteBundleContext().installBundle(bundleUrl);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("Bundle cannot be installed", (Throwable)e);
        }
    }

    public long installBundle(String bundleLocation, byte[] bundle) throws TestContainerException {
        try {
            return this.getRemoteBundleContext().installBundle(bundleLocation, bundle);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("Bundle cannot be installed", (Throwable)e);
        }
    }

    public void startBundle(long bundleId) throws TestContainerException {
        try {
            this.getRemoteBundleContext().startBundle(bundleId);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("Bundle cannot be started", (Throwable)e);
        }
    }

    public void setBundleStartLevel(long bundleId, int startLevel) throws TestContainerException {
        try {
            this.getRemoteBundleContext().setBundleStartLevel(bundleId, startLevel);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("Start level cannot be set", (Throwable)e);
        }
    }

    public void start() {
        try {
            this.getRemoteBundleContext().startBundle(0L);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("System bundle cannot be started", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.getRemoteBundleContext().stopBundle(0L);
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("System bundle cannot be stopped", (Throwable)e);
        }
    }

    public void waitForState(long bundleId, int state, long timeoutInMillis) throws org.ops4j.pax.exam.spi.container.TimeoutException {
        try {
            this.getRemoteBundleContext().waitForState(bundleId, state, timeoutInMillis);
        }
        catch (TimeoutException e) {
            throw new org.ops4j.pax.exam.spi.container.TimeoutException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new TestContainerException("Remote exception", (Throwable)e);
        }
        catch (BundleException e) {
            throw new TestContainerException("Bundle cannot be found", (Throwable)e);
        }
    }

    private RemoteBundleContext getRemoteBundleContext() {
        if (this.m_remoteBundleContext == null) {
            long startedTrying = System.currentTimeMillis();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Exception reason = null;
            try {
                Registry registry = LocateRegistry.getRegistry(this.m_rmiPort);
                do {
                    try {
                        this.m_remoteBundleContext = (RemoteBundleContext)registry.lookup(RemoteBundleContext.class.getName());
                    }
                    catch (ConnectException e) {
                        reason = e;
                    }
                    catch (NotBoundException e) {
                        reason = e;
                    }
                } while (this.m_remoteBundleContext == null && (this.m_rmiLookupTimeout == Long.MAX_VALUE || System.currentTimeMillis() < startedTrying + this.m_rmiLookupTimeout));
            }
            catch (RemoteException e) {
                reason = e;
            }
            if (this.m_remoteBundleContext == null) {
                throw new TestContainerException("Cannot get the remote bundle context", (Throwable)reason);
            }
            LOG.info((Object)("Remote bundle context found after " + (System.currentTimeMillis() - startedTrying) + " millis"));
        }
        return this.m_remoteBundleContext;
    }

    public Integer getRmiPort() {
        return this.m_rmiPort;
    }
}

