/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.path;

import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.diff.selector.RootElementSelector;
import de.danielbechler.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Deprecated
public class NodePathValueHolder<T> {
    private final Map<ElementSelector, NodePathValueHolder<T>> elementValueHolders = new HashMap<ElementSelector, NodePathValueHolder<T>>();
    private T value;

    public static <T> NodePathValueHolder<T> of(Class<T> type) {
        Assert.notNull(type, "type");
        return new NodePathValueHolder<T>();
    }

    public NodePathValueHolder<T> put(NodePath nodePath, T value) {
        this.put(nodePath.getElementSelectors(), value);
        return this;
    }

    private void put(List<ElementSelector> elementSelectors, T value) {
        if (elementSelectors.isEmpty()) {
            return;
        }
        ElementSelector elementSelector = elementSelectors.get(0);
        NodePathValueHolder<T> nodePathValueHolder = this.valueHolderForElementSelector(elementSelector);
        if (nodePathValueHolder == null) {
            nodePathValueHolder = new NodePathValueHolder<T>();
            this.elementValueHolders.put(elementSelector, nodePathValueHolder);
        }
        if (elementSelectors.size() == 1) {
            nodePathValueHolder.value = value;
        } else {
            ArrayList<ElementSelector> nodePathElementsTail = new ArrayList<ElementSelector>(elementSelectors.size() - 1);
            nodePathElementsTail.addAll(elementSelectors.subList(1, elementSelectors.size()));
            super.put(nodePathElementsTail, value);
        }
    }

    private T visit(List<T> accumulator, Iterator<ElementSelector> elementIterator) {
        if (this.value != null) {
            accumulator.add(this.value);
        }
        if (elementIterator.hasNext()) {
            ElementSelector selector = elementIterator.next();
            NodePathValueHolder<T> valueHolder = this.valueHolderForElementSelector(selector);
            if (valueHolder != null) {
                return super.visit(accumulator, elementIterator);
            }
            return null;
        }
        return this.value;
    }

    private NodePathValueHolder<T> valueHolderForElementSelector(ElementSelector elementSelector) {
        return this.elementValueHolders.get(elementSelector);
    }

    public T valueForNodePath(NodePath nodePath) {
        return (T)this.visit(new LinkedList(), nodePath.getElementSelectors().iterator());
    }

    public List<T> accumulatedValuesForNodePath(NodePath nodePath) {
        LinkedList accumulator = new LinkedList();
        this.visit(accumulator, nodePath.getElementSelectors().iterator());
        return accumulator;
    }

    public boolean containsValue(T value) {
        if (value == null && this.value == null) {
            return true;
        }
        if (value != null && value.equals(this.value)) {
            return true;
        }
        for (NodePathValueHolder<T> valueHolder : this.elementValueHolders.values()) {
            if (!valueHolder.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public void collect(Collector<T> collector) {
        this.collect(null, collector);
    }

    private void collect(NodePath nodePath, Collector<T> collector) {
        if (nodePath != null && this.value != null) {
            collector.it(nodePath, this.value);
        }
        for (Map.Entry<ElementSelector, NodePathValueHolder<T>> entry : this.elementValueHolders.entrySet()) {
            ElementSelector elementSelector = entry.getKey();
            NodePathValueHolder<T> valueHolder = entry.getValue();
            NodePath childNodePath = elementSelector == RootElementSelector.getInstance() ? NodePath.withRoot() : NodePath.startBuildingFrom(nodePath).element(elementSelector).build();
            if (valueHolder == null) continue;
            super.collect(childNodePath, collector);
        }
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder();
        this.collect(new Collector<T>(){

            @Override
            public void it(NodePath path, T value) {
                stringBuilder.append(path.toString()).append(" => ").append(value).append('\n');
            }
        });
        return stringBuilder.toString();
    }

    public void hasChildMatchingValue(NodePath nodePath, T inclusion) {
    }

    public static interface Collector<T> {
        public void it(NodePath var1, T var2);
    }
}

