/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.Visit;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.util.Strings;

public class PrintingVisitor
implements DiffNode.Visitor {
    private final Object working;
    private final Object base;

    public PrintingVisitor(Object working, Object base) {
        this.base = base;
        this.working = working;
    }

    @Override
    public void node(DiffNode node, Visit visit) {
        if (this.filter(node)) {
            String text = this.differenceToString(node, this.base, this.working);
            this.print(text);
        }
    }

    protected boolean filter(DiffNode node) {
        return node.isRootNode() && !node.hasChanges() || node.hasChanges() && !node.hasChildren();
    }

    protected String differenceToString(DiffNode node, Object base, Object modified) {
        NodePath nodePath = node.getPath();
        String stateMessage = PrintingVisitor.translateState(node.getState(), node.canonicalGet(base), node.canonicalGet(modified));
        String propertyMessage = String.format("Property at path '%s' %s", nodePath, stateMessage);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(propertyMessage);
        if (node.isCircular()) {
            stringBuilder.append(" (Circular reference detected: The property has already been processed at another position.)");
        }
        return stringBuilder.toString();
    }

    protected void print(String text) {
        System.out.println(text);
    }

    private static String translateState(DiffNode.State state, Object base, Object modified) {
        if (state == DiffNode.State.IGNORED) {
            return "has been ignored";
        }
        if (state == DiffNode.State.CHANGED) {
            return String.format("has changed from [ %s ] to [ %s ]", Strings.toSingleLineString(base), Strings.toSingleLineString(modified));
        }
        if (state == DiffNode.State.ADDED) {
            return String.format("has been added => [ %s ]", Strings.toSingleLineString(modified));
        }
        if (state == DiffNode.State.REMOVED) {
            return String.format("with value [ %s ] has been removed", Strings.toSingleLineString(base));
        }
        if (state == DiffNode.State.UNTOUCHED) {
            return "has not changed";
        }
        if (state == DiffNode.State.CIRCULAR) {
            return "has already been processed at another position. (Circular reference!)";
        }
        return '(' + state.name() + ')';
    }
}

