/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.identity;

import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class TypePropertyIdentityStrategyResolver {
    private final Map<PropertyId, IdentityStrategy> strategies = new HashMap<PropertyId, IdentityStrategy>();

    public IdentityStrategy resolve(DiffNode node) {
        if (TypePropertyIdentityStrategyResolver.isQualified(node)) {
            PropertyId propertyKey = new PropertyId(node.getParentNode().getValueType(), node.getPropertyName());
            return this.strategies.get(propertyKey);
        }
        return null;
    }

    private static boolean isQualified(DiffNode node) {
        if (node.isPropertyAware()) {
            if (node.getParentNode() == null || node.getParentNode().getValueType() == null) {
                return false;
            }
            return node.getPropertyName() != null;
        }
        return false;
    }

    public void setStrategy(IdentityStrategy identityStrategy, Class<?> type, String ... properties) {
        for (String property : properties) {
            this.strategies.put(new PropertyId(type, property), identityStrategy);
        }
    }

    private static class PropertyId {
        private final Class<?> type;
        private final String property;

        private PropertyId(Class<?> type, String property) {
            Assert.notNull(type, "type");
            Assert.notNull(property, "property");
            this.type = type;
            this.property = property;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyId that = (PropertyId)o;
            if (!this.property.equals(that.property)) {
                return false;
            }
            return this.type.equals(that.type);
        }
    }
}

