/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UseMavenCompilerPluginReleaseConfiguration
extends Recipe {
    @Option(displayName="Release version", description="The new value for the release configuration. This recipe prefers ${java.version} if defined.", example="11")
    private final Integer releaseVersion;

    public String getDisplayName() {
        return "Use Maven compiler plugin release configuration";
    }

    public String getDescription() {
        return "Replaces any explicit `source` or `target` configuration (if present) on the `maven-compiler-plugin` with `release`, and updates the `release` value if needed. Will not downgrade the Java version if the current version is higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (!this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin")) {
                    return t;
                }
                Optional maybeCompilerPluginConfig = t.getChild("configuration");
                if (!maybeCompilerPluginConfig.isPresent()) {
                    return t;
                }
                Xml.Tag compilerPluginConfig = (Xml.Tag)maybeCompilerPluginConfig.get();
                Optional source = compilerPluginConfig.getChildValue("source");
                Optional target = compilerPluginConfig.getChildValue("target");
                Optional release = compilerPluginConfig.getChildValue("release");
                if (!(source.isPresent() || target.isPresent() || release.isPresent())) {
                    return t;
                }
                if (UseMavenCompilerPluginReleaseConfiguration.this.currentNewerThanProposed(source) || UseMavenCompilerPluginReleaseConfiguration.this.currentNewerThanProposed(target) || UseMavenCompilerPluginReleaseConfiguration.this.currentNewerThanProposed(release)) {
                    return t;
                }
                Xml.Tag updated = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)t, (Xml.Tag)compilerPluginConfig, child -> !"source".equals(child.getName()) && !"target".equals(child.getName()));
                String releaseVersionValue = UseMavenCompilerPluginReleaseConfiguration.this.hasJavaVersionProperty((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)) ? "${java.version}" : UseMavenCompilerPluginReleaseConfiguration.this.releaseVersion.toString();
                return AddOrUpdateChild.addOrUpdateChild((Xml.Tag)updated, (Xml.Tag)compilerPluginConfig, (Xml.Tag)Xml.Tag.build((String)("<release>" + releaseVersionValue + "</release>")), (Cursor)this.getCursor().getParentOrThrow());
            }
        };
    }

    private boolean currentNewerThanProposed(Optional<String> config) {
        if (!config.isPresent()) {
            return false;
        }
        try {
            float currentVersion = Float.parseFloat(config.get());
            float proposedVersion = Float.parseFloat(this.releaseVersion.toString());
            return proposedVersion < currentVersion;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean hasJavaVersionProperty(Xml.Document xml) {
        return xml.getMarkers().findFirst(MavenResolutionResult.class).map(r -> r.getPom().getProperties().get("java.version") != null).orElse(false);
    }

    @Generated
    public UseMavenCompilerPluginReleaseConfiguration(Integer releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    @Generated
    public Integer getReleaseVersion() {
        return this.releaseVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseMavenCompilerPluginReleaseConfiguration(releaseVersion=" + this.getReleaseVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseMavenCompilerPluginReleaseConfiguration)) {
            return false;
        }
        UseMavenCompilerPluginReleaseConfiguration other = (UseMavenCompilerPluginReleaseConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$releaseVersion = this.getReleaseVersion();
        Integer other$releaseVersion = other.getReleaseVersion();
        return !(this$releaseVersion == null ? other$releaseVersion != null : !((Object)this$releaseVersion).equals(other$releaseVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseMavenCompilerPluginReleaseConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $releaseVersion = this.getReleaseVersion();
        result = result * 59 + ($releaseVersion == null ? 43 : ((Object)$releaseVersion).hashCode());
        return result;
    }
}

