/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt = null;
    private String asAtt = null;
    private String overrideAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    List references = new ArrayList(10);

    public void registerReference(UserFunctionCall ref) {
        this.references.add(ref);
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        this.overrideAtt = "yes";
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                if (this.nameAtt.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix", "XTSE0740");
                }
                try {
                    this.setObjectName(this.makeQName(this.nameAtt));
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
                continue;
            }
            if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("override")) {
                this.overrideAtt = Whitespace.trim(atts.getValue(a));
                if (this.overrideAtt.equals("yes")) {
                    this.override = true;
                    continue;
                }
                if (this.overrideAtt.equals("no")) {
                    this.override = false;
                    continue;
                }
                this.override = true;
                this.compileError("override must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}memo-function")) {
                String memoAtt = Whitespace.trim(atts.getValue(a));
                if (memoAtt.equals("yes")) {
                    this.memoFunction = true;
                    continue;
                }
                if (memoAtt.equals("no")) {
                    this.memoFunction = false;
                    continue;
                }
                this.compileError("saxon:memo-function must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.nameAtt = "xsl:unnamed-function";
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        this.functionName = this.nameAtt;
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            this.nameAtt = Whitespace.trim(this.getAttributeValue("name"));
            if (this.nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
            try {
                qn = this.makeQName(this.nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
        }
        return qn;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    public boolean isOverriding() {
        if (this.overrideAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.override;
    }

    public void fixupReferences() throws XPathException {
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            ((UserFunctionCall)iter.next()).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        this.getNumberOfArguments();
        XSLStylesheet root = this.getPrincipalStylesheet();
        List toplevel = root.getTopLevel();
        boolean isDuplicate = false;
        for (int i = toplevel.size() - 1; i >= 0; --i) {
            Object child = toplevel.get(i);
            if (!(child instanceof XSLFunction) || child == this || !((XSLFunction)child).getObjectName().equals(this.getObjectName()) || ((XSLFunction)child).getNumberOfArguments() != this.numberOfArguments) continue;
            if (((XSLFunction)child).getPrecedence() == this.getPrecedence()) {
                isDuplicate = true;
            }
            if (((XSLFunction)child).getPrecedence() <= this.getPrecedence()) continue;
            isDuplicate = false;
            break;
        }
        if (isDuplicate) {
            this.compileError("Duplicate function declaration", "XTSE0770");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        this.compileAsExpression(exec);
        return null;
    }

    private void compileAsExpression(Executable exec) throws XPathException {
        int tailCalls;
        Expression exp = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), false);
        if (exp == null) {
            exp = Literal.makeEmptySequence();
        }
        UserFunction fn = new UserFunction();
        fn.setHostLanguage(50);
        fn.setBody(exp);
        fn.setFunctionName(this.getObjectName(this.getNamePool()));
        this.setParameterDefinitions(fn);
        fn.setResultType(this.getResultType());
        fn.setLineNumber(this.getLineNumber());
        fn.setSystemId(this.getSystemId());
        fn.setStackFrameMap(this.stackFrameMap);
        fn.setMemoFunction(this.memoFunction);
        fn.setExecutable(exec);
        Expression exp2 = exp;
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        try {
            exp2 = visitor.typeCheck(exp, null);
            if (this.resultType != null) {
                RoleLocator role = new RoleLocator(5, this.functionName, 0, null);
                role.setSourceLocator(new ExpressionLocation(this));
                role.setErrorCode("XTTE0780");
                exp2 = TypeChecker.staticTypeCheck(exp2, this.resultType, false, role, visitor);
            }
            exp2 = exp2.optimize(visitor, null);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            this.compileError(err);
        }
        exp2 = this.getConfiguration().getOptimizer().promoteExpressionsToGlobal(exp2, visitor);
        if (this.getPreparedStylesheet().isCompileWithTracing()) {
            TraceInstruction trace = new TraceInstruction(exp2, this);
            trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            exp2 = trace;
        }
        this.allocateSlots(exp2);
        if (exp2 != exp) {
            fn.setBody(exp2);
        }
        if ((tailCalls = ExpressionTool.markTailFunctionCalls(exp2, this.getObjectName(), this.getNumberOfArguments())) != 0) {
            fn.setTailRecursive(tailCalls > 0, tailCalls > 1);
            fn.setBody(new TailCallLoop(fn));
        }
        this.fixupInstruction(fn);
        this.compiledFunction = fn;
        fn.computeEvaluationMode();
        if (this.isExplaining()) {
            exp2.explain(System.err);
        }
    }

    private void fixupInstruction(UserFunction compiledFunction) throws XPathException {
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        try {
            for (UserFunctionCall call : this.references) {
                call.setFunction(compiledFunction);
                call.checkFunctionCall(compiledFunction, visitor);
                call.computeArgumentEvaluationModes();
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Item child;
            this.numberOfArguments = 0;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) instanceof XSLParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = new UserFunctionParameter[this.getNumberOfArguments()];
        fn.setParameterDefinitions(params);
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = (NodeInfo)kids.next()) != null) {
            if (!(node instanceof XSLParam)) continue;
            UserFunctionParameter param = new UserFunctionParameter();
            params[count++] = param;
            param.setRequiredType(((XSLParam)node).getRequiredType());
            param.setVariableQName(((XSLParam)node).getVariableQName());
            param.setSlotNumber(((XSLParam)node).getSlotNumber());
            ((XSLParam)node).fixupBinding(param);
            int refs = ExpressionTool.getReferenceCount(fn.getBody(), param, false);
            param.setReferenceCount(refs);
        }
        return;
    }

    public UserFunction getCompiledFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 149;
    }
}

