package org.nuiton.wikitty.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.UnhandledException;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.jdbc.WikittyServiceJDBC;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.Button;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author sherkhan
 */
public class LoginController extends GenericForwardComposer {

    protected ProxyModel _proxyModel = new ProxyModel();
    protected Listbox dataList;
    protected ApplicationConfig _config = new ApplicationConfig();
    protected Properties _properties = new Properties();

    public LoginController() throws IOException {
        initConfig();
        loadProperties();
        createProxyDatas();
    }

    @Override
    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);

        Window window = (Window) comp;
        Groupbox box = (Groupbox) window.getFellow("loginPassword");
        box.setVisible(false);
        disableUpdateButtons();
    }

    public void initConfig() {
        _config.setConfigFileName("wikitty-ui-zk.properties");
        try {
            _config.parse(new String[]{});
        } catch (ArgumentsParserException ex) {
            throw new UnhandledException(ex);
        }
    }

    protected void disableUpdateButtons() {
        Button update = (Button) self.getFellow("update");
        if (update.isDisabled() == false) {
            update.setDisabled(true);
        }
        update = (Button) self.getFellow("distantUpdate");
        if (!update.isDisabled()) {
            update.setDisabled(true);
        }
    }

    protected void enableLocalUpdateButton() {
        Button update = (Button) self.getFellow("update");
        if (update.isDisabled()) {
            update.setDisabled(false);
        }
    }

    protected void enableDistantUpdateButton() {
        Button update = (Button) self.getFellow("distantUpdate");
        if (update.isDisabled()) {
            update.setDisabled(false);
        }
    }

    protected void saveNewData(Data data) throws FileNotFoundException, IOException {
        String name = "";
        String path = "";
        for (int count = 0; name != null; ++count) {
            path = "data" + count;
            name = _properties.getProperty(path + ".name");
        }
        _properties.setProperty(path + ".name", data.getName());
        String db = data.getDb();
        if (!db.isEmpty()) {
            _properties.setProperty(path + ".db", db);
        }
        String driver = data.getDriver();
        if (!driver.isEmpty()) {
            _properties.setProperty(path + ".driver", driver);
        }
        String solr = data.getSolr();
        if (!solr.isEmpty()) {
            _properties.setProperty(path + ".solr", solr);
        }
        String url = data.getUrl();
        if (!url.isEmpty()) {
            _properties.setProperty(path + ".url", url);
        }
        String login = data.getLogin();
        String password = data.getPassword();
        if (!login.isEmpty()) {
            _properties.setProperty(path + ".login", login);
            _properties.setProperty(path + ".password", password);
        }
        data.setPath(path);
        saveProperties();
        createProxyDatas();
    }

    protected void saveUpdateData(Data data) throws IOException {
        String path = data.getPath();
        _properties.setProperty(path + ".name", data.getName());
        String db = data.getDb();
        if (!db.isEmpty()) {
            _properties.setProperty(path + ".db", db);
        }
        String driver = data.getDriver();
        if (!driver.isEmpty()) {
            _properties.setProperty(path + ".driver", driver);
        }
        String solr = data.getSolr();
        if (!solr.isEmpty()) {
            _properties.setProperty(path + ".solr", solr);
        }
        String url = data.getUrl();
        if (!url.isEmpty()) {
            _properties.setProperty(path + ".url", url);
        }
        saveProperties();
        createProxyDatas();
    }

    protected void loadProperties() throws IOException {
        String filePath = _config.getOption("wikitty-ui-zk.filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        InputStream stream = new FileInputStream(file);
        _properties.load(stream);
        stream.close();
    }

    protected void saveProperties() throws IOException {
        String filePath = _config.getOption("wikitty-ui-zk.filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStream stream = new FileOutputStream(file);
        _properties.store(stream, null);
        stream.close();
    }

    protected void createProxyDatas() {
        List<Data> datas = new ArrayList<Data>();
        String name = "";
        for (int count = 0; name != null; ++count) {
            String path = "data" + count;
            name = _properties.getProperty(path + ".name");
            if (name != null) {
                String db = _properties.getProperty(path + ".db");
                String solr = _properties.getProperty(path + ".solr");
                String driver = _properties.getProperty(path + ".driver");
                String url = _properties.getProperty(path + ".url");
                String login = _properties.getProperty(path + ".login");
                String password = _properties.getProperty(path + ".password");
                Data data = new Data(name, db, driver, solr, url, login, password);
                data.setPath(path);
                datas.add(data);
            }
        }
        _proxyModel.setProxyDatas(datas);
    }

    protected void removeDataFromProperties(Data data) {
        String path = data.getPath();
        if (_properties.containsKey(path + ".name")) {
            _properties.remove(path + ".name");
        }
        if (_properties.containsKey(path + ".db")) {
            _properties.remove(path + ".db");
        }
        if (_properties.containsKey(path + ".driver")) {
            _properties.remove(path + ".driver");
        }
        if (_properties.containsKey(path + ".solr")) {
            _properties.remove(path + ".solr");
        }
        if (_properties.containsKey(path + ".url")) {
            _properties.remove(path + ".url");
        }
        if (_properties.containsKey(path + ".login")) {
            _properties.remove(path + ".login");
        }
        if (_properties.containsKey(path + ".password")) {
            _properties.remove(path + ".password");
        }
    }

    protected WikittyProxy createLocalProxy(Properties properties, String login, String password) {
        WikittyProxy proxy = new WikittyProxy();
        try {
            WikittyService ws = new WikittyServiceJDBC(properties);
            ws = new WikittyServiceCached(ws);
            proxy.setWikittyService(ws);
        } catch (Exception eee) {
            return null;
        }
        if (!login.isEmpty()) {
            proxy.login(login, password);
        }
        return proxy;
    }

    protected void goToWikittyPage(WikittyProxy proxy) {
        Sessions.getCurrent().setAttribute("proxy", proxy);
        Executions.sendRedirect("wikitty.zul");
    }

    protected void fillDistantProxy(Data data) {
        ((Textbox) this.self.getFellow("distantName")).setValue(data.getName());
        ((Textbox) this.self.getFellow("distantURL")).setValue(data.getUrl());
        enableDistantUpdateButton();
    }

    protected void fillLocalProxy(Data data) {
        ((Textbox) this.self.getFellow("name")).setValue(data.getName());
        ((Textbox) this.self.getFellow("solr")).setValue(data.getSolr());
        ((Textbox) this.self.getFellow("db")).setValue(data.getDb());
        ((Combobox) this.self.getFellow("driver")).setValue(data.getDriver());
        enableLocalUpdateButton();
    }

     protected void clearAllLocalFields() {
        Textbox input = (Textbox) self.getFellow("name");
        input.setValue("");
        input = (Textbox) self.getFellow("solr");
        input.setValue("");
        input = (Textbox) self.getFellow("db");
        input.setValue("");
        input = (Textbox) self.getFellow("login");
        input.setValue("");
        input = (Textbox) self.getFellow("password");
        input.setValue("");
        Combobox box = (Combobox) self.getFellow("driver");
        box.setText(null);
    }

    protected void clearAllDistantFields() {
        Textbox input = (Textbox) self.getFellow("distantName");
        input.setValue("");
        input = (Textbox) self.getFellow("distantURL");
        input.setValue("");
        input = (Textbox) self.getFellow("distantLogin");
        input.setValue("");
        input = (Textbox) self.getFellow("distantPassword");
        input.setValue("");
    }

    /*
     * Events
     */
    public void onSelect$dataList() {
        Listitem item = dataList.getSelectedItem();
        if (item != null) {
            disableUpdateButtons();
            Data data = (Data) item.getValue();
            String login = data.getLogin();
            String password = data.getPassword();
            Groupbox box = (Groupbox) this.self.getFellow("loginPassword");
            if (box != null) {
                if (!password.isEmpty() && !login.isEmpty()) {
                    box.setVisible(true);
                    Textbox loginText = (Textbox) box.getFellow("selectLogin");
                    loginText.setValue("");
                    Textbox passwordText = (Textbox) box.getFellow("selectPassword");
                    passwordText.setValue("");
                } else {
                    box.setVisible(false);
                }
            }
            clearAllDistantFields();
            clearAllLocalFields();
        }
    }

    public void onClick$modify() {
        Listitem item = dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data) item.getValue();
            String url = data.getUrl();
            if (!url.isEmpty()) {
                fillDistantProxy(data);
            } else {
                fillLocalProxy(data);
            }
        }
    }

    public void onClick$update() throws IOException {
        Listitem item = dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data) item.getValue();
            String name = ((Textbox) this.self.getFellow("name")).getValue();
            String db = ((Textbox) this.self.getFellow("db")).getValue();
            String solr = ((Textbox) this.self.getFellow("solr")).getValue();
            Combobox box = (Combobox) this.self.getFellow("driver");
            String driver = "";
            Comboitem boit = box.getSelectedItem();
            if (boit != null) {
                driver = boit.getLabel();
            }
            if (!name.isEmpty() && !db.isEmpty() && !solr.isEmpty() && !driver.isEmpty()) {
                data.setAll(name, db, driver, solr, null, data.getLogin(), data.getPassword());
                saveUpdateData(data);
                disableUpdateButtons();
            }
        }
    }

    public void onClick$distantUpdate() throws IOException {
        Listitem item = dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data) item.getValue();
            String name = ((Textbox) this.self.getFellow("distantName")).getValue();
            String URL = ((Textbox) this.self.getFellow("distantURL")).getValue();
            if (!name.isEmpty() && !URL.isEmpty()) {
                data.setAll(name, null, null, null, URL, data.getLogin(), data.getPassword());
                saveUpdateData(data);
                disableUpdateButtons();
            }
        }
    }

    public void onClick$select() throws ArgumentsParserException {
        Listitem item = dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data) item.getValue();
            String login = ((Textbox) this.self.getFellow("selectLogin")).getValue();
            String password = ((Textbox) this.self.getFellow("selectPassword")).getValue();
            if (data.hasLoginPassword()) {
                if (!login.equals(data.getLogin()) || !password.equals(password)) {
                    return;
                }
            }
            WikittyProxy proxy = null;
            if (data.getUrl().isEmpty()) {
                Properties properties = getLocalProperties(data);
                proxy = createLocalProxy(properties, login, password);
            }
            if (proxy != null) {
                goToWikittyPage(proxy);
            }
        }
    }

    public void onClick$add() throws FileNotFoundException, IOException {
        String name = ((Textbox) this.self.getFellow("name")).getValue();
        String db = ((Textbox) this.self.getFellow("db")).getValue();
        String solr = ((Textbox) this.self.getFellow("solr")).getValue();
        String login = ((Textbox) this.self.getFellow("login")).getValue();
        String password = ((Textbox) this.self.getFellow("password")).getValue();
        String driver = "";
        Combobox box = (Combobox) this.self.getFellow("driver");
        Comboitem item = box.getSelectedItem();
        if (item != null) {
            driver = item.getLabel();
        }
        if (!name.isEmpty() && !db.isEmpty() && !solr.isEmpty() && !driver.isEmpty()) {
            Data data = new Data(name, db, driver, solr, null, login, password);
            saveNewData(data);
        }
    }

    public void onClick$distantAdd() throws FileNotFoundException, IOException {
        String name = ((Textbox) this.self.getFellow("distantName")).getValue();
        String URL = ((Textbox) this.self.getFellow("distantURL")).getValue();
        String login = ((Textbox) this.self.getFellow("distantLogin")).getValue();
        String password = ((Textbox) this.self.getFellow("distantPassword")).getValue();
        if (!name.isEmpty() && !URL.isEmpty()) {
            Data data = new Data(name, null, null, null, URL, login, password);
            saveNewData(data);
        }
    }

    public void onClick$delete() throws IOException {
        Set<Listitem> set = dataList.getSelectedItems();
        List<Listitem> items = new ArrayList<Listitem>(set);
        if (items != null) {
            for (Listitem item : items) {
                Data data = (Data) item.getValue();
                removeDataFromProperties(data);
                _proxyModel.removeData(data);
            }
            saveProperties();
            disableUpdateButtons();
        }
    }

    /*
     * Renderers
     */
    public ListitemRenderer getDataRenderer() {
        return new ListitemRenderer() {

            @Override
            public void render(Listitem item, Object data) throws Exception {
                item.setValue(data);
                String proxyName = ((Data) data).getName();
                if (!((Data) data).getUrl().isEmpty()) {
                    proxyName += " (Distant)";
                }
                item.setLabel(proxyName);
            }
        };
    }

    /*
     * Setters
     */

    /*
     * Getters
     */
    public ProxyModel getProxyModel() {
        return _proxyModel;
    }

    public Properties getLocalProperties(Data data) throws ArgumentsParserException {
        ApplicationConfig config = new ApplicationConfig();
        config.parse(new String[]{});
        Properties properties = config.getFlatOptions();
        properties.setProperty("solr.data.dir", data.getSolr());
        properties.setProperty("jdbc.con.driver", data.getDriver());
        properties.setProperty("jdbc.con.host", data.getDb());
        properties.setProperty("jdbc.con.userName", "sa");
        properties.setProperty("jdbc.con.password", "");
        System.setProperty("solr.data.dir", data.getSolr());
        return properties;
    }
}
