/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.ScriptEvaluator;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.publication.AbstractActionOnWikitty;
import org.nuiton.wikitty.publication.ActionError;
import org.nuiton.wikitty.publication.WikittyPublicationContext;
import org.nuiton.wikitty.search.Criteria;

public class ActionEval
extends AbstractActionOnWikitty {
    private static Log log = LogFactory.getLog(ActionError.class);
    public static final String EVAL_VAR = "wpEval";
    public static final String CONTEXT_VAR = "wpContext";
    public static final String SUBCONTEXT_VAR = "wpSubContext";
    public static final String PAGE_NAME_VAR = "wpPage";
    public static final String WIKITTY_VAR = "wpWikitty";
    protected static final String exampleUsage = "eval/WikittyPubText.name=Wiki/WikittyPubText.content?mimetype=WikittyPubText.mimetype\neval/Tuto\neval/Tuto/WikittyPubText.content\neval/WikittyPubText.name=Tuto/WikittyPubText.content\neval/WikittyPubText.name=Tuto/WikittyPubText.content?mimetype=WikittyPubText.mimetype\neval/Command.id=df/Command.script?mimetype=Command.mimetype\n";
    protected ApplicationConfig appConfig;
    protected ScriptEngineManager scriptEnginManager;

    public ActionEval(ApplicationConfig appConfig) {
        this.appConfig = appConfig;
        this.scriptEnginManager = new ScriptEngineManager();
    }

    public Object doAction(WikittyPublicationContext context, List<String> subContext) {
        Object result;
        log.info((Object)("path " + subContext));
        Criteria criteria = this.searchCriteria(subContext);
        if (criteria == null) {
            result = "";
        } else {
            WikittyProxy proxy = context.getWikittyProxy();
            Wikitty w = proxy.findByCriteria(criteria);
            if (w == null) {
                context.setContentType("text/plain");
                result = String.format("no data found for criteria '%s'", criteria);
            } else {
                String contentField = this.getContentFieldName(context, criteria.getName(), w);
                if (contentField == null) {
                    result = this.getError(context);
                } else {
                    String extName = WikittyExtension.extractExtensionName((String)contentField);
                    String fieldName = WikittyExtension.extractFieldName((String)contentField);
                    String mimetype = this.getMimeType(context, criteria.getName(), w);
                    String content = w.getFieldAsString(extName, fieldName);
                    subContext = new ArrayList<String>(subContext.subList(1, subContext.size()));
                    HashMap<String, Object> bindings = new HashMap<String, Object>();
                    bindings.put(PAGE_NAME_VAR, criteria.getName());
                    bindings.put(CONTEXT_VAR, context);
                    bindings.put(SUBCONTEXT_VAR, subContext);
                    bindings.put(WIKITTY_VAR, w);
                    bindings.put(EVAL_VAR, this);
                    result = ScriptEvaluator.eval(null, (String)criteria.getName(), (String)content, (String)mimetype, bindings);
                }
            }
        }
        return result;
    }

    public Object doAction(WikittyPublicationContext context, String subContextAsText) {
        Object result;
        if (subContextAsText == null || "".equals(subContextAsText)) {
            result = this.getError(context);
        } else {
            if (subContextAsText.startsWith("/")) {
                subContextAsText = subContextAsText.substring(1);
            }
            String[] subContextArray = StringUtil.split((String)subContextAsText, (String)"/");
            List<String> subContext = Arrays.asList(subContextArray);
            result = this.doAction(context, subContext);
        }
        return result;
    }

    public Object doAction(WikittyPublicationContext context) {
        Object result = context.getMandatoryArguments().size() <= 0 ? this.getError(context) : this.doAction(context, context.getMandatoryArguments());
        return result;
    }

    protected String getExampleUsage() {
        return exampleUsage;
    }
}

