/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.publication.AbstractActionOnWikitty;
import org.nuiton.wikitty.publication.ActionError;
import org.nuiton.wikitty.publication.WikittyPublicationContext;
import org.nuiton.wikitty.search.Criteria;

public class ActionRaw
extends AbstractActionOnWikitty {
    private static Log log = LogFactory.getLog(ActionError.class);
    protected static final String exampleUsage = "ram/WikittyPubData.name=MonImage.jpg/WikittyPubData.content?mimetype=WikittyPubData.mimetype\nram/Tuto\nram/Tuto/WikittyPubText.content\nram/WikittyPubText.name=Tuto/WikittyPubText.content\nram/WikittyPubText.name=Tuto/WikittyPubText.content?mimetype=WikittyPubText.mimetype\nram/WikittyUser.login=admin/WikittyUser.password?mimetype=text/plain\n";
    protected ApplicationConfig appConfig;

    public ActionRaw(ApplicationConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected String getExampleUsage() {
        return exampleUsage;
    }

    public Object doAction(WikittyPublicationContext context) {
        Object result;
        log.info((Object)("args " + context.getMandatoryArguments()));
        Criteria criteria = this.searchCriteria(context.getMandatoryArguments());
        if (criteria == null) {
            result = this.getError(context);
        } else {
            WikittyProxy proxy = context.getWikittyProxy();
            Wikitty w = proxy.findByCriteria(criteria);
            if (w == null) {
                context.setContentType("text/plain");
                result = String.format("no data found for criteria %s", criteria);
            } else {
                String contentField = this.getContentFieldName(context, criteria.getName(), w);
                if (contentField == null) {
                    result = this.getError(context);
                } else {
                    String extName = WikittyExtension.extractExtensionName((String)contentField);
                    String fieldName = WikittyExtension.extractFieldName((String)contentField);
                    String mimetype = this.getMimeType(context, criteria.getName(), w);
                    context.setContentType(mimetype);
                    result = w.getFieldAsObject(extName, fieldName);
                }
            }
        }
        return result;
    }
}

