/*
 * #%L
 * Wikitty :: publication
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.publication.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class WikittyPubTextHelper {

    /**
     * WikittyPubTextHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyPubTextHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_NAME, name);
        return oldValue;
}

    /**
     * getMimeType :
     * @param wikitty 
     * @return String 
     */

    public static String getMimeType(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_MIMETYPE);
        return value;
}

    /**
     * setMimeType :
     * @param wikitty 
     * @param mimeType 
     * @return String 
     */

    public static String setMimeType(Wikitty wikitty, String mimeType) {
        String oldValue = getMimeType(wikitty);
        wikitty.setField(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_MIMETYPE, mimeType);
        return oldValue;
}

    /**
     * getContent :
     * @param wikitty 
     * @return String 
     */

    public static String getContent(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_CONTENT);
        return value;
}

    /**
     * setContent :
     * @param wikitty 
     * @param content 
     * @return String 
     */

    public static String setContent(Wikitty wikitty, String content) {
        String oldValue = getContent(wikitty);
        wikitty.setField(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_CONTENT, content);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_NAME);
            Object f2 = w2.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_MIMETYPE);
            Object f2 = w2.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_MIMETYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_CONTENT);
            Object f2 = w2.getFieldAsObject(WikittyPubText.EXT_WIKITTYPUBTEXT, WikittyPubText.FIELD_WIKITTYPUBTEXT_CONTENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyPubText.EXT_WIKITTYPUBTEXT);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyPubTextAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyPubTextHelper
