/* *##% 
 * ToPIA :: SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;

import java.io.File;
import java.io.IOException;

/**
 * Meta generateur des services
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.TopiaApplicationServiceMetaGenerator"
 */
public class TopiaApplicationServiceMetaGenerator extends ObjectModelGenerator {

    /** logger */
    private static final Log log = LogFactory.getLog(TopiaApplicationServiceMetaGenerator.class);

    @Override
    public void applyTemplate(ObjectModel model, File destDir) throws IOException {

        generateApplicationService(model, destDir);
        
    }

    /**
     * Appel les autres generateurs des services.
     * 
     * @param model le modele à utiliser pour la génération
     * @param destDir le répertoire où générer
     * @throws IOException si des erreurs d'IO pendant la génération
     */
    public void generateApplicationService(ObjectModel model, File destDir)
            throws IOException {

        ObjectModelGenerator gen;
        
        // Genere les interfaces des services
        if(log.isDebugEnabled()) {
            log.debug("Generating Service Interface");
        }
        gen = new ServiceInterfaceGenerator();
        gen.setParent(this);
        gen.applyTemplate(model, destDir);
        
        // Genere les abstract des services
        if(log.isDebugEnabled()) {
            log.debug("Generating Service Abstract");
        }
        gen = new ServiceAbstractGenerator();
        gen.setParent(this);
        gen.applyTemplate(model, destDir);
        
        // Genere les impl des services
        if(log.isDebugEnabled()) {
            log.debug("Generating Service Impl");
        }
        gen = new ServiceImplGenerator();
        gen.setParent(this);
        gen.applyTemplate(model, destDir);
    }

} //TopiaApplicationServiceMetaGenerator
