/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class ServiceImplGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(ServiceImplGenerator.class);

    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + "Impl.java";
    }

    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
        if (!interfacez.hasStereotype("service")) {
            return;
        }
        if (interfacez.getOperations().size() > 0) {
            return;
        }
        for (ObjectModelClassifier parent : interfacez.getInterfaces()) {
            ObjectModelClass clazz;
            if (!parent.hasStereotype("dao")) continue;
            String entityClassName = null;
            entityClassName = parent.getQualifiedName().replace("DAO", "");
            if (!((ObjectModel)this.getModel()).hasClass(entityClassName) || (clazz = ((ObjectModel)this.getModel()).getClass(entityClassName)).getOperations().size() <= 0) continue;
            return;
        }
        this.generateInterfaceHeader(output, (ObjectModelClassifier)interfacez);
        output.write("} //" + interfacez.getName() + "\n");
        output.write("");
    }

    private void generateInterfaceHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright((Model)this.model);
        String classifierName = classifier.getName();
        if (TopiaGeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + classifier.getPackageName() + ";");
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)classifier)) {
            output.write("\n");
            output.write("/**\n");
            output.write(" *\n");
            output.write(" * " + classifier.getDocumentation() + "\n");
            output.write(" */\n");
            output.write("");
        }
        output.write("\n");
        output.write("\n");
        output.write("public class " + classifierName + "Impl extends " + classifierName + "Abstract { ");
    }
}

