/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationImplementor;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationService;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public abstract class AbstractReplicationEngineTest
extends Assert {
    protected static TopiaContext context;
    protected static TopiaContext ctxt;
    protected TopiaContextImplementor dstCtxt;
    protected TopiaReplicationImplementor service;
    protected ReplicationModel model;
    protected static boolean init;
    private static Long testsTimeStamp;
    private static File testsBasedir;
    private static final String TEST_BASEDIR = "target%1$ssurefire-tests%1$s%2$td_%2$tm_%2$tY%1$s%2$tH_%2$tM_%2$tS";
    private static int dbCounter;

    public static void after() throws Exception {
        if (context != null && !context.isClosed()) {
            try {
                context.closeContext();
            }
            catch (TopiaException topiaException) {
                // empty catch block
            }
        }
        init = false;
    }

    public void setUp() throws Exception {
        if (!init) {
            I18n.init((Locale)Locale.FRANCE);
            try {
                context = this.createDb("source");
            }
            catch (Exception e) {
                this.getLog().error((Object)"could not create db source.", (Throwable)e);
                throw e;
            }
            init = true;
        }
        ctxt = context.beginTransaction();
        this.service = (TopiaReplicationImplementor)context.getService(TopiaReplicationService.class);
    }

    public void tearDown() throws Exception {
        if (ctxt != null) {
            ctxt.rollbackTransaction();
            ctxt.closeContext();
            ctxt = null;
        }
        this.service = null;
    }

    protected abstract TopiaContext createDb2(String var1) throws Exception;

    protected abstract TopiaContext createDb(String var1) throws Exception;

    protected TopiaContext createReplicateDb(Object contract) throws Exception {
        TopiaContext rootCtxt = this.createDb2(contract.toString() + dbCounter++);
        return rootCtxt;
    }

    protected abstract TopiaEntityEnum[] getContracts();

    protected abstract Log getLog();

    protected <E extends TopiaEntity> E update(E e) throws TopiaException {
        Class k = TopiaEntityHelper.getContractClass((TopiaEntityEnum[])this.getContracts(), e.getClass());
        TopiaDAO dao = ((TopiaContextImplementor)ctxt).getDAO(k);
        return (E)dao.findByTopiaId(e.getTopiaId());
    }

    public void testDetectTypes() throws Exception {
    }

    public void testGetOperation() throws Exception {
    }

    public void testDetectAssociations() throws Exception {
    }

    public void testDetectDirectDependencies() throws Exception {
    }

    public void testDetectShell() throws Exception {
    }

    public void testDetectDependencies() throws Exception {
    }

    public void testDetectObjectsToDettach() throws Exception {
    }

    public void testDetectOperations() throws Exception {
    }

    public void testDoReplicate() throws Exception {
    }

    protected void detectTypes(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        Set detectTypes = this.service.detectTypes(this.getContracts(), new String[]{entity.getTopiaId()});
        AbstractReplicationEngineTest.assertEquals((String)("expected types : " + Arrays.toString(expectedCouple) + " but was " + detectTypes), (long)expectedCouple.length, (long)detectTypes.size());
        for (Object o : expectedCouple) {
            AbstractReplicationEngineTest.assertTrue((boolean)detectTypes.contains(o));
        }
    }

    protected void getOperation(Class<? extends TopiaReplicationOperation> operationClass, boolean shouldExist) throws TopiaException {
        TopiaReplicationOperation operation = this.service.getOperation(operationClass);
        AbstractReplicationEngineTest.assertEquals((Object)shouldExist, (Object)(operation != null ? 1 : 0));
    }

    protected void detectAssociations(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        AbstractReplicationEngineTest.assertEquals((long)0L, (long)(expectedCouple.length % 2));
        int j = expectedCouple.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum src = (TopiaEntityEnum)expectedCouple[2 * i];
            String name = (String)expectedCouple[2 * i + 1];
            ReplicationNode nodeSrc = this.model.getNode(src);
            AbstractReplicationEngineTest.assertNotNull((String)("association " + name + " not found"), (Object)nodeSrc);
            AbstractReplicationEngineTest.assertTrue((boolean)nodeSrc.hasAssociation());
            AbstractReplicationEngineTest.assertTrue((boolean)nodeSrc.getAssociations().containsKey(name));
        }
    }

    protected void detectDirectDependencies(TopiaEntity entity, Object ... expectedCouple) throws TopiaException {
        this.createModel(entity);
        this.model.detectDirectDependencies();
        AbstractReplicationEngineTest.assertEquals((long)0L, (long)(expectedCouple.length % 2));
        int j = expectedCouple.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum src = (TopiaEntityEnum)expectedCouple[2 * i];
            String name = (String)expectedCouple[2 * i + 1];
            ReplicationNode nodeSrc = this.model.getNode(src);
            AbstractReplicationEngineTest.assertTrue((String)(nodeSrc + " should have dependency but was not!"), (boolean)nodeSrc.hasDependency());
            AbstractReplicationEngineTest.assertTrue((String)(nodeSrc + " should contain dependency " + name + "but was not! (" + nodeSrc.getDependencies() + ")"), (boolean)nodeSrc.getDependencies().containsKey(name));
        }
    }

    protected void detectShell(TopiaEntity entity, TopiaEntityEnum ... expected) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        TopiaEntityEnum c = TopiaEntityHelper.getEntityEnum(entity.getClass(), (TopiaEntityEnum[])this.getContracts());
        AbstractReplicationEngineTest.assertNotNull((Object)c);
        Set shell = this.model.getNode(c.getContract()).getShell();
        AbstractReplicationEngineTest.assertEquals((String)("expected shell : " + Arrays.toString(expected) + ", but was " + shell), (long)expected.length, (long)shell.size());
        for (TopiaEntityEnum type : expected) {
            ReplicationNode node = this.model.getNode(type.getContract());
            AbstractReplicationEngineTest.assertTrue((boolean)shell.contains(node));
            AbstractReplicationEngineTest.assertEquals((Object)type, (Object)node.getContract());
        }
    }

    protected void detectDependencies(TopiaEntity entity, TopiaEntityEnum[] ... expected) throws TopiaException {
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        this.model.detectDependencies();
        List dependencies = this.model.getOrder();
        boolean i = false;
        for (ReplicationNode level : dependencies) {
            this.getLog().info((Object)("level " + level + " = " + level));
        }
    }

    protected void detectObjectsToDettach(TopiaEntity entity, Object ... expected) throws TopiaException {
        AbstractReplicationEngineTest.assertEquals((long)0L, (long)(expected.length % 2));
        this.createModel(entity);
        this.model.detectAssociations(new TopiaEntityEnum[0]);
        this.model.detectDirectDependencies();
        this.model.detectShell();
        this.model.detectDependencies();
        this.model.detectObjectsToDettach();
        HashSet<ReplicationNode> nodes = new HashSet<ReplicationNode>();
        int j = expected.length / 2;
        for (int i = 0; i < j; ++i) {
            TopiaEntityEnum e = (TopiaEntityEnum)expected[2 * i];
            ReplicationNode node = this.model.getNode(e);
            String[] ids = (String[])expected[2 * i + 1];
            AbstractReplicationEngineTest.assertEquals((Object)(ids.length > 0 ? 1 : 0), (Object)node.hasAssociationsToDettach());
            for (String id : ids) {
                AbstractReplicationEngineTest.assertTrue((boolean)node.getAssociationsToDettach().contains(id));
            }
            nodes.add(node);
        }
        for (ReplicationNode node : this.model.getNodes()) {
            if (nodes.contains(node)) continue;
            AbstractReplicationEngineTest.assertFalse((boolean)node.hasAssociationsToDettach());
        }
    }

    protected void detectOperations(TopiaEntity entity, Object ... expected) throws TopiaException {
        AbstractReplicationEngineTest.assertEquals((long)0L, (long)(expected.length % 2));
        if (entity == null) {
            this.prepareModel(new String[0]);
        } else {
            this.prepareModel(entity.getTopiaId());
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)"==========================================================================");
            if (entity == null) {
                this.getLog().info((Object)"resume of operations for all ");
            } else {
                this.getLog().info((Object)("resume of operations for entity " + entity.getTopiaId()));
            }
            for (ReplicationNode node : this.model.getOrder()) {
                List operations = node.getOperations();
                for (ReplicationOperationDef op : operations) {
                    this.getLog().info((Object)("[" + node + "] : operation " + op));
                }
            }
            this.getLog().info((Object)"==========================================================================");
        }
    }

    protected void doReplicate(TopiaEntityEnum contract, TopiaEntity ... entity) throws Exception {
        TopiaContext rootCtxt = this.createReplicateDb("doReplicate_" + contract);
        List ids = TopiaEntityHelper.getTopiaIdList(Arrays.asList(entity));
        this.getLog().info((Object)("entity " + ids));
        this.prepareModel(ids.toArray(new String[ids.size()]));
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
        this.service.doReplicate(this.model, (TopiaContext)this.dstCtxt);
        if (entity.length == 0) {
            return;
        }
        this.dstCtxt = (TopiaContextImplementor)rootCtxt.beginTransaction();
        for (TopiaEntity e : entity) {
            TopiaEntity actual = this.dstCtxt.findByTopiaId(e.getTopiaId());
            AbstractReplicationEngineTest.assertNotNull((Object)actual);
            AbstractReplicationEngineTest.assertEquals((Object)e, (Object)actual);
        }
        this.dstCtxt.closeContext();
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
    }

    protected void doReplicateAll() throws Exception {
        TopiaContext rootCtxt = this.createReplicateDb("doReplicateAll");
        this.prepareModelAll();
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
        this.service.doReplicate(this.model, (TopiaContext)this.dstCtxt);
        TopiaContextImplementor ctxt2 = (TopiaContextImplementor)ctxt;
        this.dstCtxt = (TopiaContextImplementor)rootCtxt.beginTransaction();
        this.assertDbEquals(this.model.getContracts(), (TopiaContextImplementor)ctxt, ctxt2);
        this.dstCtxt.closeContext();
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
    }

    protected void doReplicateWithComputedOrder(TopiaEntity ... entity) throws Exception {
        TopiaContext rootCtxt = this.createReplicateDb("doReplicateWithComputedOrder");
        List ids = TopiaEntityHelper.getTopiaIdList(Arrays.asList(entity));
        this.prepareModelWithComputedOrder(ids.toArray(new String[ids.size()]));
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
        this.service.doReplicate(this.model, (TopiaContext)this.dstCtxt);
        this.getLog().info((Object)("replication is done for " + Arrays.toString(entity) + ", will verify data..."));
        TopiaContextImplementor ctxt2 = (TopiaContextImplementor)ctxt;
        this.dstCtxt = (TopiaContextImplementor)rootCtxt.beginTransaction();
        this.assertDbEquals(this.model.getContracts(), (TopiaContextImplementor)ctxt, ctxt2);
        this.dstCtxt.closeContext();
        this.dstCtxt = (TopiaContextImplementor)rootCtxt;
    }

    protected void assertDbEquals(TopiaEntityEnum[] contracts, TopiaContextImplementor ctxt, TopiaContextImplementor ctxt2) throws TopiaException {
        HashSet<String> ids = new HashSet<String>();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)("will verify db for contracts " + Arrays.toString(contracts)));
        }
        for (TopiaEntityEnum c : contracts) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("verify for contract " + c));
            }
            TopiaDAO daoSrc = ctxt.getDAO(c.getContract());
            TopiaDAO daoDst = ctxt2.getDAO(c.getContract());
            long nbSrc = daoSrc.size();
            long nbDst = daoDst.size();
            AbstractReplicationEngineTest.assertEquals((String)("le nombres d'entites de type " + c + " devrait etre " + nbSrc + " mais est " + nbDst), (long)nbSrc, (long)nbDst);
            List idsSrc = daoSrc.findAllIds();
            List idsDst = daoDst.findAllIds();
            Collections.sort(idsSrc);
            Collections.sort(idsDst);
            AbstractReplicationEngineTest.assertEquals((Object)idsSrc, (Object)idsDst);
            for (String id : idsSrc) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("verify for entity " + id));
                }
                TopiaEntity eSrc = daoSrc.findByTopiaId(id);
                TopiaEntity eDst = daoDst.findByTopiaId(id);
                AbstractReplicationEngineTest.assertEquals((Object)eSrc, (Object)eDst);
                this.assertEntityEquals(eSrc, eDst, ids);
            }
        }
    }

    protected void assertEntityEquals(TopiaEntity expected, TopiaEntity actual, Set<String> treated) {
        Object dst;
        Object src;
        Class type;
        TopiaEntityEnum contract;
        if (treated == null) {
            treated = new HashSet<String>();
        }
        if (treated.contains(actual.getTopiaId())) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)expected);
        }
        AbstractReplicationEngineTest.assertEquals((Object)actual.getTopiaId(), (Object)expected.getTopiaId());
        treated.add(actual.getTopiaId());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("expected : " + expected + " / actual " + actual));
        }
        if ((contract = TopiaEntityHelper.getEntityEnum(expected.getClass(), (TopiaEntityEnum[])this.getContracts())) == null) {
            this.getLog().debug((Object)("untested property type " + expected.getClass()));
            return;
        }
        Assert.assertNotNull((String)("contract not found for " + expected.getClass() + " in " + Arrays.toString(this.getContracts())), (Object)contract);
        EntityOperator operator = EntityOperatorStore.getOperator((TopiaEntityEnum)contract);
        List associationProperties = operator.getAssociationProperties();
        for (String name : associationProperties) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("association " + name));
            }
            if (operator.isChildEmpty(name, expected)) {
                AbstractReplicationEngineTest.assertTrue((String)("l'association " + name + " devrait etre vide mais possede " + operator.sizeChild(name, actual) + " entrees"), (boolean)operator.isChildEmpty(name, actual));
            } else {
                AbstractReplicationEngineTest.assertFalse((String)("l'association " + name + " devrait posseder " + operator.isChildEmpty(name, expected) + " mais est vide"), (boolean)operator.isChildEmpty(name, actual));
            }
            AbstractReplicationEngineTest.assertEquals((Object)operator.isChildEmpty(name, actual), (Object)operator.isChildEmpty(name, expected));
            type = operator.getAssociationPropertyType(name);
            src = (Collection)operator.get(name, expected);
            dst = (Collection)operator.get(name, actual);
            Iterator itrSrc = src.iterator();
            Iterator itrDst = dst.iterator();
            while (itrSrc.hasNext()) {
                if (TopiaEntity.class.isAssignableFrom(type)) {
                    this.assertEntityEquals((TopiaEntity)itrSrc.next(), (TopiaEntity)itrDst.next(), treated);
                    continue;
                }
                AbstractReplicationEngineTest.assertEquals(itrSrc.next(), itrDst.next());
            }
        }
        for (String name : operator.getProperties()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("dependency " + name));
            }
            if (associationProperties.contains(name)) continue;
            type = operator.getPropertyType(name);
            src = operator.get(name, expected);
            dst = operator.get(name, actual);
            AbstractReplicationEngineTest.assertFalse((src == null && dst != null ? 1 : 0) != 0);
            AbstractReplicationEngineTest.assertFalse((src != null && dst == null ? 1 : 0) != 0);
            if (src == null) continue;
            if (TopiaEntity.class.isAssignableFrom(type)) {
                this.assertEntityEquals((TopiaEntity)src, (TopiaEntity)dst, treated);
                continue;
            }
            AbstractReplicationEngineTest.assertEquals((Object)src, (Object)dst);
        }
    }

    protected void createUnsupportedBeforeOperation(TopiaEntityEnum contract, TopiaEntity entity, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) throws Exception {
        this.getLog().info((Object)("entity " + entity.getTopiaId()));
        this.prepareModel(entity.getTopiaId());
        this.service.addBeforeOperation(this.model, contract, operationClass, parameters);
        AbstractReplicationEngineTest.fail();
    }

    protected void createUnsupportedAfterOperation(TopiaEntityEnum contract, TopiaEntity entity, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) throws Exception {
        this.getLog().info((Object)("entity " + entity.getTopiaId()));
        this.prepareModel(entity.getTopiaId());
        this.service.addAfterOperation(this.model, contract, operationClass, parameters);
        AbstractReplicationEngineTest.fail();
    }

    protected synchronized Long getTestsTimeStamp() {
        if (testsTimeStamp == null) {
            testsTimeStamp = System.currentTimeMillis();
            this.getLog().info((Object)("tests timestamp : " + testsTimeStamp));
        }
        return testsTimeStamp;
    }

    protected synchronized File getTestDir(Class<?> testClass) {
        if (testsBasedir == null) {
            String tmp = System.getProperty("basedir");
            if (tmp == null) {
                tmp = new File("").getAbsolutePath();
            }
            String name = String.format(TEST_BASEDIR, File.separator, new Date(this.getTestsTimeStamp()));
            testsBasedir = new File(new File(tmp), name);
            this.getLog().info((Object)("tests basedir   : " + testsBasedir));
        }
        return new File(testsBasedir, testClass.getSimpleName());
    }

    protected void createModel(TopiaEntity entity) throws TopiaException {
        this.model = this.service.createModel(this.getContracts(), new String[]{entity.getTopiaId()});
    }

    protected void prepareModel(String ... ids) throws TopiaException {
        this.model = this.service.prepare(this.getContracts(), ids);
    }

    protected void prepareModelAll() throws TopiaException {
        this.model = this.service.prepareForAll(this.getContracts());
    }

    protected void prepareModelWithComputedOrder(String ... ids) throws TopiaException {
        this.model = this.service.prepareWithComputedOrder(this.getContracts(), ids);
    }
}

