package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaIdFactory.java 2798 2013-08-14 13:09:05Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaIdFactory.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * This API represents an ID generation strategy
 * <p/>
 * // TODO AThimel 20/07/13 Javadoc (finish this javadoc)
 *
 * @author bleny <leny@codelutin.com/>
 * @author tchemit <chemit@codelutin.com/>
 * @since 3.0
 */
public interface TopiaIdFactory {

    /**
     * Generates a new topia id for the given entity type and the given entity.
     *
     * @param entityClass type of entity (must be a not null interface)
     * @param topiaEntity the entity on which we want to generate the id (must be not null)
     * @param <E>         type of entity
     * @return the new topia id for the given entity
     */
    <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity);

    /**
     * @param topiaId the topia id to inspect
     * @param <E>     type of the entity
     * @return the fqn part of the topia id
     */
    <E extends TopiaEntity> Class<E> getClassName(String topiaId);

    /**
     * @param topiaId the topia id to inspect
     * @return the random poart of the topia id.
     */
    String getRandomPart(String topiaId);

    /**
     * @return the separator between the fqn and the random part of any topia id.
     */
    String getSeparator();
}
