/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.actions;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;
import org.nuiton.scmwebeditor.SvnConnection;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class UploadAction
extends ScmWebEditorBaseAction
implements ServletRequestAware {
    private static final long serialVersionUID = 4244339447567114412L;
    private static final Log log = LogFactory.getLog(UploadAction.class);
    public static final String REDIRECT = "redirect";
    protected File upload;
    protected String uploadFileName;
    protected String uploadContentType;
    protected String username;
    protected String pw;
    protected String svnPath;
    protected String address;
    protected String svnRoot;
    protected String fileRoot;
    protected boolean badLogin;
    protected boolean error;
    protected transient HttpServletRequest request;

    public String getSvnPath() {
        return this.svnPath;
    }

    public void setSvnPath(String svnPath) {
        this.svnPath = svnPath;
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public boolean isError() {
        return this.error;
    }

    public String getSvnRoot() {
        return this.svnRoot;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    public String execute() {
        File checkoutDir;
        SvnConnection svnConn;
        SvnConnection svnConnection = new SvnConnection(this.address);
        this.svnRoot = svnConnection.getSvnRoot();
        this.fileRoot = svnConnection.getSvnPath();
        if (this.svnRoot == null) {
            this.svnRoot = this.fileRoot;
        }
        try {
            svnConn = new SvnConnection(this.address);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error when creating SvnSession in UploadAction", (Throwable)e);
            }
            this.error = true;
            return "error";
        }
        String repositoryUUID = svnConn.getUUID();
        if (repositoryUUID == null) {
            repositoryUUID = this.address;
        }
        if (this.username == null && this.pw == null) {
            if (this.getScmSession().getUsername(repositoryUUID) != null && this.getScmSession().getPassword(repositoryUUID) != null) {
                this.username = this.getScmSession().getUsername(repositoryUUID);
                this.pw = this.getScmSession().getPassword(repositoryUUID);
            } else {
                this.username = null;
                this.pw = null;
            }
        } else {
            this.getScmSession().addScmUser(repositoryUUID, this.username, this.pw);
        }
        svnConn.updateAuthentication(this.username, this.pw);
        try {
            svnConn.testConnection();
        }
        catch (SVNException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test connection fail", (Throwable)e);
            }
            this.getScmSession().delScmUser(repositoryUUID);
            this.username = null;
            this.pw = null;
        }
        if (this.upload == null) {
            return REDIRECT;
        }
        this.badLogin = false;
        this.error = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileName : " + this.uploadFileName));
            log.debug((Object)("ContentType : " + this.uploadContentType));
        }
        SVNUpdateClient upclient = new SVNUpdateClient((ISVNRepositoryPool)svnConn.getManager(), (ISVNOptions)svnConn.getSvnOption());
        try {
            svnConn.createCheckoutdir();
            checkoutDir = svnConn.getCheckoutdir();
        }
        catch (IOException e1) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create checkoutDir", (Throwable)e1);
            }
            this.error = true;
            return "error";
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do Checkout of " + this.svnRoot));
            }
            upclient.doCheckout(SVNURL.parseURIEncoded((String)this.svnRoot), checkoutDir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Private SCM on reading " + svnConn.getRemoteUrl()));
            }
            this.delTempDirectory(checkoutDir);
            this.error = true;
            return "error";
        }
        catch (SVNException e) {
            this.delTempDirectory(checkoutDir);
            this.error = true;
            return "error";
        }
        if (!this.svnPath.endsWith("/")) {
            this.svnPath = this.svnPath + "/";
        }
        String checkoutPath = checkoutDir.getAbsolutePath();
        File file = new File(checkoutPath + this.svnPath.replace(this.svnRoot, ""), this.uploadFileName);
        try {
            FileUtils.copyFile((File)this.upload, (File)file);
        }
        catch (IOException e) {
            this.error = true;
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't copy the file to the checkout directory", (Throwable)e);
            }
            return "error";
        }
        SVNClientManager manager = svnConn.getManager();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("leSvnPath : " + file.toString()));
            }
            manager.getWCClient().doAdd(file, false, false, false, SVNDepth.EMPTY, false, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Add success !");
            }
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Erreur SVN Add", (Throwable)e);
            }
            this.error = true;
            this.delTempDirectory(checkoutDir);
            return "error";
        }
        File[] checkoutDirTab = new File[]{checkoutDir};
        try {
            manager.getCommitClient().doCommit(checkoutDirTab, false, "From scmwebeditor -- add the file : " + this.uploadFileName, null, null, false, true, SVNDepth.INFINITY);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Commit success !");
            }
        }
        catch (SVNAuthenticationException authexep) {
            if (log.isErrorEnabled()) {
                log.error((Object)"authentification fail");
            }
            this.badLogin = true;
            this.delTempDirectory(checkoutDir);
            this.getScmSession().delScmUser(repositoryUUID);
            return "login";
        }
        catch (SVNException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Erreur SVN commit", (Throwable)e);
            }
            this.error = true;
            this.delTempDirectory(checkoutDir);
            return "error";
        }
        this.delTempDirectory(checkoutDir);
        if (log.isDebugEnabled()) {
            log.debug((Object)"File upload successful");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.username + " with IP " + this.request.getRemoteAddr() + " add the file " + this.getUploadFileName() + " on the repository."));
        }
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

