/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: ScmUrlResolverDefaultImpl.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.3/src/main/java/org/nuiton/scmwebeditor/urlResolver/impl/ScmUrlResolverDefaultImpl.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.urlResolver.impl;

import org.apache.commons.lang.StringUtils;
import org.nuiton.scmwebeditor.urlResolver.ScmUrlResolver;

import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class ScmUrlResolverDefaultImpl implements ScmUrlResolver {

    public static final String DEFAULT_NAME = "default";

    public static final String PARAMETER_ADDRESS = "address";

    @Override
    public String getLayoutName() {
        return DEFAULT_NAME;
    }

    @Override
    public URL resolv(Map<String, String> parameters) throws IOException, IllegalArgumentException {
        String result = parameters.get(PARAMETER_ADDRESS);
        if (StringUtils.isEmpty(result)) {
            throw new IllegalArgumentException(
                    "Layout " + DEFAULT_NAME + " requires a parameter '" +
                    PARAMETER_ADDRESS + "'");
        }
        return new URL(result);
    }

}


