<%--
  #%L
  ScmWebEditor
  
  $Id: modificationViewer.jsp 249 2011-08-26 15:24:50Z tchemit $
  $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.2/src/main/webapp/WEB-INF/content/modificationViewer.jsp $
  %%
  Copyright (C) 2009 - 2011 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as 
  published by the Free Software Foundation, either version 3 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Lesser Public License for more details.
  
  You should have received a copy of the GNU General Lesser Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/lgpl-3.0.html>.
  #L%
  --%>
<%-- Document : ModificationViewer Created on : 10 sept. 2009, 13:43:11 Author : glorieux --%>

<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<sj:head jquerytheme="default"/>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
  <title>SCMWebEditor</title>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
  <script type="text/javascript" src="js/selectLanguage.js"></script>


  <!-- Code mirror -->
  <!-- First the CodeMirror stuff  -->
  <script src="codemirror-ui/lib/CodeMirror-2.1/lib/codemirror.js"
          type="text/javascript"></script>
  <link rel="stylesheet"
        href="codemirror-ui/lib/CodeMirror-2.1/lib/codemirror.css">


  <script src="codemirror-ui/lib/CodeMirror-2.1/mode/rst/rst.js"></script>
  <link rel="stylesheet"
        href="codemirror-ui/lib/CodeMirror-2.1/mode/rst/rst.css">

  <script src="codemirror-ui/lib/CodeMirror-2.1/mode/clike/clike.js"></script>
  <link rel="stylesheet"
        href="codemirror-ui/lib/CodeMirror-2.1/mode/clike/clike.css">

  <link rel="stylesheet"
        href="codemirror-ui/lib/CodeMirror-2.1/theme/default.css">

  <script
    src="codemirror-ui/lib/CodeMirror-2.1/mode/htmlmixed/htmlmixed.js"></script>
  <script
    src="codemirror-ui/lib/CodeMirror-2.1/mode/javascript/javascript.js"></script>
  <script src="codemirror-ui/lib/CodeMirror-2.1/mode/css/css.js"></script>
  <script src="codemirror-ui/lib/CodeMirror-2.1/mode/xml/xml.js"></script>

  <script src="codemirror-ui/lib/CodeMirror-2.1/mode/stex/stex.js"></script>

  <!-- Then the CodeMirrorUI stuff  -->
  <script src="codemirror-ui/js/codemirror-ui.js"
          type="text/javascript"></script>
  <link rel="stylesheet" href="codemirror-ui/css/codemirror-ui.css"
        type="text/css" media="screen"/>


  <script src="js/cancelRedirect.js" type="text/javascript"></script>
  <script src="js/pictureUpload.js" type="text/javascript"></script>


  <link rel="icon" href="img/ScmWebEditor_little.png" type="image/png">
  <link rel="stylesheet" type="text/css" href="css/main.css">


</head>
<body>
<div id="wrapper">

<form method="POST" action="commit.action" id="editForm">

<div id="head">


<div id="flagEdit">

  <ul>
    <li>
      <s:if
        test="%{#session['WW_TRANS_I18N_LOCALE'] != null && #session['WW_TRANS_I18N_LOCALE'].language == 'en'}">
        <img src="img/flag-i18n-uk.png"/>
      </s:if>
      <s:else>
        <s:a action="checkout.action" namespace="/">
          <s:param name="address"><s:property value="address"/></s:param>
          <s:param name="request_locale">en_GB</s:param>
          <img src="img/flag-i18n-uk.png"/>
        </s:a>
      </s:else>
    </li>
    <li>
      <s:if
        test="%{#session['WW_TRANS_I18N_LOCALE'] == null || #session['WW_TRANS_I18N_LOCALE'].language == 'fr'}">
        <img src="img/flag-i18n-fr.png"/>
      </s:if>
      <s:else>
        <s:a action="checkout.action" namespace="/">
          <s:param name="address"><s:property value="address"/></s:param>
          <s:param name="request_locale">fr_FR</s:param>
          <img src="img/flag-i18n-fr.png"/>
        </s:a>
      </s:else>
    </li>

  </ul>

</div>


<!--     <a title="ScmWebEditor Project Website" target="_blank" href="http://maven-site.nuiton.org/scmwebeditor/"><img width="200" height="160" src="img/editor/machine-a-ecrire.png" alt="ScmWebEditor logo"/></a> -->

<h1 id="editorTitle">SCMWebEditor</h1>


<!--     authentification   -->
<div id="headLogin">

  <div id="authDiv">
    <h3><s:text name="scm.connection"/></h3>

    <s:if test="username==null || pw==null">
      <s:set id="scm.username">
        <s:text name="scm.username"/>
      </s:set>
      <s:set id="scm.usernameTitle">
        <s:text name="scm.usernameTitle"/>
      </s:set>
      <s:set id="scm.password">
        <s:text name="scm.password"/>
      </s:set>
      <s:set id="scm.passwordTitle">
        <s:text name="scm.passwordTitle"/>
      </s:set>

      <s:textfield accesskey="U" size="12" label="%{scm.username}"
                   name="username" title="%{scm.usernameTitle}"/>
      <s:password accesskey="P" size="12" label="%{scm.password}" name="pw"
                  title="%{scm.passwordTitle}"/>
      <input type="checkbox" name="saveCookie" value="true"><s:text
      name="scm.stayLogin"/>
    </s:if>
    <s:else>

      <s:set id="addressDeco">
        <s:property value="address"/>
      </s:set>
      <s:set id="projectUrlDeco">
        <s:property value="projectUrl"/>
      </s:set>
      <s:a
        id="logout"
        href="logout.action?address=%{addressDeco}&projectUrl=%{projectUrlDeco}"
        title="Logout"
        >
        <div id="logoutButton"></div>
      </s:a>

      <s:text name="scm.logAs"/> <s:property value="username"/>


      <br/>
    </s:else>

    <div id="htmlcontentCommit">
      <s:if test="badLogin">
        <p>
          <font color="red">
            <s:text name="scm.badUsernameOrPassword"/>
          </font>
        </p>
      </s:if>
    </div>


  </div>


  <noscript>
    <s:set id="scm.saveAndQuitTitle">
      <s:text name="scm.saveAndQuitTitle"/>
    </s:set>
    <s:submit
      value="commit"
      title="Deconnexion"
      name="Save"
      />
  </noscript>

  <div id="buttonList">

    <!--BEGIN Save and continue -->
    <s:url id="ajaxCommit" value="save.action"/>

    <s:set id="scm.saveAndContinueTitle">
      <s:text name="scm.saveAndContinueTitle"/>
    </s:set>
    <sj:a
      onclick="loadChange()"
      id="ajaxSaveButton"
      formIds="editForm"
      targets="htmlcontentCommit"
      href="%{ajaxCommit}"
      title="%{scm.saveAndContinueTitle}"
      >
      <div id="saveButton"></div>
    </sj:a>
    <!--END Save and continue -->

    <!--BEGIN preview -->

    <s:if test="format=='rst'">
      <s:url id="ajaxPreview" value="preview.action"/>

      <s:set id="scm.preview">
        <s:text name="scm.preview"/>
      </s:set>
      <sj:a onclick="loadChange()"
            id="ajaxPreviewButton"
            formIds="editForm"
            targets="htmlcontentPreview"
            href="%{ajaxPreview}"
            title="%{scm.preview}"

        >
        <div id="previewButton"></div>
      </sj:a>
    </s:if>

    <!--END preview -->

    <!--BEGIN reset -->

    <s:set id="scm.resetTitle">
      <s:text name="scm.resetTitle"/>
    </s:set>
    <sj:a
      title="%{scm.resetTitle}"
      formIds="editForm"
      id="resetButton"
      targets="htmlcontentCommit"
      href="reset.action"
      >
      <div id="resetButton"></div>
    </sj:a>

    <!--END reset -->

    <!-- BEGIN save and exit -->
    <s:set id="scm.saveAndQuitTitle">
      <s:text name="scm.saveAndQuitTitle"/>
    </s:set>

    <s:a
      href="javascript:document.getElementById('editForm').submit();"
      title="%{scm.saveAndQuitTitle}"
      name="Save"
      >
      <div id="saveAndQuitButton"></div>
    </s:a>

    <!-- END save and exit -->

    <!-- BEGIN exit -->

    <s:if test="projectUrl!=null">
      <s:hidden key="projectUrl" label=''/>
    </s:if>
    <s:else>
      <s:hidden id="projectUrl" value="checkout.action"/>
    </s:else>


    <s:set id="scm.exitTitle">
      <s:text name="scm.exitTitle"/>
    </s:set>
    <s:set id="scm.exitJavascript">
      <s:text name="scm.exitJavascript"/>
    </s:set>

    <s:a
      href="#"
      title="%{scm.exitTitle}"
      value="%{scm.exit}"
      name="Cancel"
      onclick="return cancelRedirect('%{scm.exitJavascript}',document.getElementById('projectUrl'));">
      <div id="exitButton"></div>
    </s:a>

    <!-- END exit -->

  </div>
</div>


<s:set id="scm.commitMessage">
  <s:text name="scm.commitMessage"/>
</s:set>
<s:set id="scm.commitMessageTitle">
  <s:text name="scm.commitMessageTitle"/>
</s:set>

<div id="commitArea">
  <s:textarea cols="60" label="%{scm.commitMessage} " name="commitMessage"
              title="%{scm.commitMessageTitle}"></s:textarea>
</div>
</div>


<s:hidden key="format" label=''/>
<s:hidden key="mimeType" label=''/>

<s:if test="format=='rst'">
  <h4><s:text name="scm.info.ProblemWithRst"/> <a
    href="http://docutils.sourceforge.net/docs/user/rst/quickref.html"><s:text
    name="scm.info.rstWebsite"/></a>.</h4>
</s:if>


<p>
  <s:text name="scm.FileInEditor"/> <s:a href="%{address}"><s:property
  value="address"/></s:a>
  <s:text name="scm.atRevision"/> <span id="numrevisionDiv"><s:property
  value="numRevision"/></span>
</p>


<textarea id="newTextId" rows="50" cols="80" name="newText"><s:property
  escapeHtml="false" value="OrigText"/></textarea>


<script type="text/javascript">
  var textarea = document.getElementById('newTextId');
  var uiOptions = { path : 'codemirror-ui/js/', searchMode : 'inline' }
  var codeMirrorOptions = { mode: "null" }
  var editor = new CodeMirrorUI(textarea, uiOptions, codeMirrorOptions);
</script>


<label><s:text name="scm.language"/>
  <select id="language" name="langageSelection"
          onchange="changeModeBy(editor,this)">
    <option value="null"><s:text name="scm.text"/></option>
    <option value="rst">ReStructuredText</option>
    <option value="javascript">Javascript</option>
    <option value="text/html">HTML</option>
    <option value="xml">XML</option>
    <option value="text/x-java">JAVA</option>
    <option value="css">CSS</option>
    <option value="stex">LaTeX</option>
  </select>
</label>


<script type='text/javascript'>
  selectLanguage('<s:property value="mimeType"/>', '<s:property value="format"/>');
  changeModeBy(editor, document.getElementById('language'));
</script>


<script type="text/javascript">
  function loadChange() {
    document.getElementById('newTextId').value = editor.mirror.getValue();
  }
</script>


<noscript><h4><s:text name="scm.modificationViewer.noJavascript"/></h4>
</noscript>
<noscript><h4><s:text name="scm.modificationViewer.betterUseJavascript"/></h4>
</noscript>

<div id="form">


  <p>


    <s:hidden key="address" label=''/>
    <s:hidden key="origText" label=''/>
    <s:hidden key="scmEditorUrl" label=''/>


  <div id="scmButton"></div>

</div>
</form>

<s:set id="scm.upload">
  <s:text name="scm.upload"/>
</s:set>
<s:set id="scm.uploadTitle">
  <s:text name="scm.uploadTitle"/>
</s:set>

<s:set name="address">
  <s:property value="address"/>
</s:set>
<center>
  <s:submit name="uploadButton" value="%{scm.upload}" title="%{scm.uploadTitle}"
            onClick="javascript:upload_popup('doUpload.action', 'upload' , getElementById('address') );"/>
</center>


<div>


</div>


<!--
    <div id="uploadFormId" >
        <s:form method="POST" id="uploadForm" action="uploadFile" enctype="multipart/form-data">

            
            <label>Upload a picture : <input type="file" name="upload"/></label><br/>
            <label>Path on svn : <input type="text" name="svnPath" /></label><br/>
            <label>username : <input type="text" name="username" /></label><br/>
            <label>password : <input type="password" name="pw" /></label><br/>
            
            <sj:submit
                id="ajaxUploadButton" 
                targets="targetContentUpload" 
                button="true" 
                value="upload"
                >
            </sj:submit>
           
        </s:form>
    </div>
     -->

<div id="targetContentUpload"></div>


<div id="htmlcontentPreview"></div>

</div>
<p align="right">&#169;2004-2009 CodeLutin</p>
</body>
</html>
