/*
 * #%L
 * ScmWebEditor
 * 
 * $Id: PreviewAction.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.2/src/main/java/org/nuiton/scmwebeditor/actions/PreviewAction.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.actions;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.jrst.JRST;
import org.nuiton.scmwebeditor.ScmWebEditorBaseAction;

import javax.servlet.http.HttpServletRequest;

public class PreviewAction extends ScmWebEditorBaseAction implements ServletRequestAware {

    /**
     *
     */
    private static final long serialVersionUID = -2388759298175611718L;

    private static final Log log = LogFactory.getLog(PreviewAction.class);

    protected transient HttpServletRequest request;

    protected String XMLResponse;

    protected String newText;

    public String getNewText() {
        return newText;
    }

    public void setNewText(String newText) {
        this.newText = newText;
    }

    public String getXMLResponse() {
        return XMLResponse;
    }


    public void setXMLResponse(String XMLResponse) {
        this.XMLResponse = XMLResponse;
    }

    public String execute() {

        if (log.isDebugEnabled()) {
            log.debug("Enter in preview action");
        }

        if (log.isDebugEnabled()) {
            log.debug(newText);
        }
        XMLResponse = "";
        //Using jrst to generate html document
        try {
            XMLResponse = JRST.generate(JRST.TYPE_HTML, newText);
            if (log.isDebugEnabled()) {
                log.debug("RST generate");
            }

        } catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("RST generate fail", eee);
            }
            XMLResponse = "<h4>Parsing error, please read RST specification<h4>";
        }

        return SUCCESS;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }


}
