/*
 * #%L
 * Nuiton-ScmWebEditor
 * 
 * $Id: ScmWebEditorBaseAction.java 248 2011-08-26 15:09:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/scmwebeditor/tags/scmwebeditor-0.2/src/main/java/org/nuiton/scmwebeditor/ScmWebEditorBaseAction.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor;

import com.opensymphony.xwork2.ActionContext;
import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.ByteOrderMarkDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.nuiton.web.struts2.BaseAction;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.xml.sax.SAXException;

import javax.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

/**
 * User: chemit
 * Date: 24 nov. 2009
 * Time: 21:24:39
 */
public class ScmWebEditorBaseAction extends BaseAction {

    public static final String AUTH_ERROR = "authError";

    public static final String ERROR_PATH = "errorPath";

    protected Map<String, Object> session;

    private static final long serialVersionUID = 1L;

    final static protected String CONTEXT_ACTION_KEY = "action";

    private static final Log log = LogFactory.getLog(ScmWebEditorBaseAction.class);

    //TODO-TC200924 : uniformize all this different parameter and attribute, this is a bit messy...
    protected static final String PARAMETER_ADDRESS = "address";

    protected static final String PARAMETER_SCM_EDITOR_URL = "scmEditorUrl";

    protected static final String PARAMETER_PROJECT_URL = "projectUrl";

    protected static final String PARAMETER_FILE_NAME = "file_name";

    protected static final String PARAMETER_LANG = "lang";

    protected static final String PARAMETER_DEFAULT_LANG = "defaultLang";

    protected static final String PARAMETER_FORMAT = "format";

    protected static final String PARAMETER_USERNAME = "username";

    protected static final String PARAMETER_PW = "pw";

    protected static final String PARAMETER_MYTEXT = "Mytext";

    protected static final String PARAMETER_ORIG_TEXT = "Orig_text";

    protected static final String PARAMETER_COMMIT_MESSAGE = "Commit_message";

    protected static final String PARAMETER_TEXT = "text";

    //protected static final String ATTRIBUTE_TEMPDIR = "javax.servlet.context.tempdir";
    //    protected static final String ATTRIBUTE_SVN_PATH_URL = "svnPath_url";
//    protected static final String ATTRIBUTE_FILE_NAME_URL = "fileName_url";
    protected static final String ATTRIBUTE_REDIRECTION_URL = "Redirection_url";

    //    protected static final String ATTRIBUTE_LANG = "Lang";
    //    protected static final String ATTRIBUTE_FORMAT = "Format";
    private static final String ATTRIBUTE_SVN_SESSION = "myInfo";

    protected static final String ATTRIBUTE_ORIG_TEXT = "OrigText";

    protected static final String ATTRIBUTE_INVALIDATE_MAX_TIME = "InvalidateMaxTime";

    protected static final String ATTRIBUTE_LOGIN = "Login";

    protected static final String ATTRIBUTE_IS_LOGIN = "IsLogin";

    protected static final String ATTRIBUTE_BAD_LOGIN = "badLogin";

    protected static final String ATTRIBUTE_PROJECT_URL = "projectUrl";

    protected static final String ATTRIBUTE_SCM_EDITOR_URI = "scmEditorUri";

    protected static final String ATTRIBUTE_PREVIEW_SERVLET_URL = "previewServletUrl";

    protected static final String ATTRIBUTE_FILESEARCH_SERVLET_URL = "searchServletUrl";

    protected static final String ATTRIBUTE_REDIRECT_URL = "Redirect_url";

    protected static final String ATTRIBUTE_PRIVATE_SERVLET_URI = "privateServletUri";

    protected static final String PROPERTIESFILES = "scmwebeditor.properties";

    protected static final String EDITABLESFILES = "editableFiles";


    protected static CodepageDetectorProxy detector;

    protected CodepageDetectorProxy getCodepageDetector() {

        if (detector == null) {
            detector = CodepageDetectorProxy.getInstance(); // A singleton.

            // Add the implementations of info.monitorenter.cpdetector.io.ICodepageDetector:
            // This one is quick if we deal with unicode codepages:
            detector.add(new ByteOrderMarkDetector());
            // The first instance delegated to tries to detect the meta charset attribut in html pages.
            detector.add(new ParsingDetector(true)); // be verbose about parsing.
            // This one does the tricks of exclusion and frequency detection, if first implementation is
            // unsuccessful:
            detector.add(JChardetFacade.getInstance()); // Another singleton.
            detector.add(ASCIIDetector.getInstance()); // Fallback, see javadoc.
        }
        return detector;
    }


    /**
     * Convert all files to UTF-8.
     *
     * @param files fiels to convert
     */
    protected void convertToUnicode(File... files) {

        CodepageDetectorProxy myDetector = getCodepageDetector();

        for (File file : files) {
            try {
                Charset charset = myDetector.detectCodepage(file.toURI().toURL());

                if (log.isDebugEnabled()) {
                    log.debug("Charset for " + file.getAbsolutePath() + " is " + charset);
                }

                if (charset != null && !charset.name().equalsIgnoreCase("UTF-8")) {

                    if (log.isDebugEnabled()) {
                        log.debug("Convert " + file.getAbsolutePath() + " to unicode");
                    }

                    File tmpFile = File.createTempFile(file.getName(), ".copy");
                    tmpFile.deleteOnExit();

                    // direct copy
                    InputStream is = new FileInputStream(file);
                    OutputStream os = new FileOutputStream(tmpFile);
                    try {
                        IOUtils.copy(is, os);
                    } finally {
                        is.close();
                        os.close();
                    }

                    // copy using cp transaltion
                    is = new FileInputStream(tmpFile);
                    os = new FileOutputStream(file);
                    Reader ir = new InputStreamReader(is, charset);
                    Writer ow = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
                    try {
                        IOUtils.copy(ir, ow);
                    } finally {
                        ir.close();
                        ow.close();
                        is.close();
                        os.close();
                    }

                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("File " + file.getAbsolutePath() + " already in unicode : skip");
                    }
                }
            } catch (MalformedURLException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't convert file in unicode", e);
                }
            } catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't convert file in unicode", e);
                }
            }
        }
    }

    /**
     * @param svnSess
     * @param checkoutdir
     * @throws SVNException
     */
    public void checkout(SvnConnection svnSess, File checkoutdir, String numVersion) throws SVNException {

        SVNUpdateClient upclient = new SVNUpdateClient(svnSess.getManager(), svnSess.getSvnOption());

        if (log.isDebugEnabled()) {
            log.debug("Do Checkout of " + svnSess.getRemoteUrl());
        }
        try {
            upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir,
                                SVNRevision.create(Long.parseLong(numVersion)), SVNRevision.create(Long.parseLong(numVersion)), SVNDepth.FILES, false);
        } catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                log.error("The number version is not valid.");
            }
            upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir,
                                SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.FILES, false);

        }


    }

    /**
     * @param svnSess
     * @param checkoutdir
     * @throws SVNException
     */
    public void checkout(SvnConnection svnSess, File checkoutdir) throws SVNException {

        SVNUpdateClient upclient = new SVNUpdateClient(svnSess.getManager(), svnSess.getSvnOption());

        if (log.isDebugEnabled()) {
            log.debug("Do Checkout of " + svnSess.getRemoteUrl());
        }

        upclient.doCheckout(svnSess.getRemoteUrl(), checkoutdir,
                            SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.FILES, false);
    }


    /**
     * @param svnFile
     * @param username
     * @param password
     * @return
     * @throws SVNException
     * @throws IOException
     */
    public String getHeadRevision(String address, String login, String password) throws SVNException, IllegalArgumentException {

        String lastRevision;

        SvnConnection svnConn = new SvnConnection(address);


        String url = svnConn.getSvnPath();
        String file = svnConn.getFileName();


        SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(url));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(login, password);
        repository.setAuthenticationManager(authManager);

        SVNNodeKind nodeKind = repository.checkPath(file, -1);


        if (nodeKind == SVNNodeKind.NONE) {
            if (log.isErrorEnabled()) {
                log.error("There is no entry at '" + url + "'.");
            }
            throw new IllegalArgumentException("There is no entry at '" + url + "'.");
        } else if (nodeKind == SVNNodeKind.DIR) {
            if (log.isErrorEnabled()) {
                log.error("The entry at '" + url + "' is a file while a directory was expected.");
            }
            throw new IllegalArgumentException("The entry at '" + url + "' is a file while a directory was expected.");
        }


        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        SVNProperties fileProperties = new SVNProperties();

        repository.getFile(file, -1, fileProperties, baos);

        fileProperties.getStringValue(SVNProperty.REVISION);


        lastRevision = baos.toString();

        try {
            baos.close();
        } catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Can't close stream", e);
            }
        }

        return lastRevision;
    }


    public String getHeadNumberRevision(String address, String login, String password) throws SVNException {

        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(login, password);

        DefaultSVNOptions svnOption = new DefaultSVNOptions();
        svnOption.setPropertyValue(SVNProperty.EOL_STYLE, SVNProperty.EOL_STYLE_LF);

        SVNWCClient wcClient = new SVNWCClient(authManager, svnOption);

        SVNInfo info = wcClient.doInfo(SVNURL.parseURIEncoded(address), SVNRevision.HEAD, SVNRevision.HEAD);

        String headRevision = info.getRevision().toString();


        return headRevision;
    }

    public String getHeadcommiter(String address, String login, String password) throws SVNException {

        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(login, password);

        DefaultSVNOptions svnOption = new DefaultSVNOptions();
        svnOption.setPropertyValue(SVNProperty.EOL_STYLE, SVNProperty.EOL_STYLE_LF);

        SVNWCClient wcClient = new SVNWCClient(authManager, svnOption);

        SVNInfo info = wcClient.doInfo(SVNURL.parseURIEncoded(address), SVNRevision.HEAD, SVNRevision.HEAD);

        String headAuthor = info.getAuthor();


        return headAuthor;
    }


    /**
     * Use to delete the checkout temp directory
     *
     * @param checkoutdir The dir temp directory
     */
    public void delTempDirectory(File checkoutdir) {
        try {
            FileUtils.deleteDirectory(checkoutdir);
        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't delete temp directory");
            }
        }
    }


    protected SvnConnection getSvnSession(HttpSession httpSession) {
        SvnConnection svnSess = (SvnConnection) httpSession.getAttribute(ATTRIBUTE_SVN_SESSION);
        return svnSess;
    }

    protected void setSvnSession(HttpSession httpSession, SvnConnection svnSess) {
        httpSession.setAttribute(ATTRIBUTE_SVN_SESSION, svnSess);
    }

    protected File getTempDir(HttpSession httpSession) {
        File tmp_dir = getSvnSession(httpSession).getCheckoutdir();
        return tmp_dir;
    }


    protected String getMimeType(File file) throws IOException, SAXException, TikaException {
        InputStream is = new FileInputStream(file);
        String result = null;
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set(Metadata.RESOURCE_NAME_KEY, file.getName());
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(is, contenthandler, metadata);
            result = metadata.get(Metadata.CONTENT_TYPE);
            if (log.isDebugEnabled()) {
                log.debug("Mine type of " + file.getName() + " is : " + result);
            }

        } catch (SAXException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get MimeType, parsing error", e);
            }
        } catch (TikaException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get MimeType, tika error", e);
            }
        } finally {
            is.close();
        }
        return result;
    }

    protected String getMimeType(String content, String filename) throws IOException {
        InputStream is = new ByteArrayInputStream(content.getBytes());
        String result = null;
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set(Metadata.RESOURCE_NAME_KEY, filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(is, contenthandler, metadata);
            result = metadata.get(Metadata.CONTENT_TYPE);
            if (log.isDebugEnabled()) {
                log.debug("Mine type of " + filename + " is : " + result);
            }

        } catch (SAXException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get MimeType, parsing error", e);
            }
        } catch (TikaException e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get MimeType, tika error", e);
            }
        } finally {
            is.close();
        }
        return result;
    }

    protected String[] getMimeTypes(String content, String filename) throws IOException, SAXException, TikaException {
        InputStream is = new ByteArrayInputStream(content.getBytes());
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            metadata.set(Metadata.RESOURCE_NAME_KEY, filename);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(is, contenthandler, metadata);
            String[] result = metadata.getValues(Metadata.CONTENT_TYPE);

            if (log.isDebugEnabled()) {
                log.debug("Mine type of " + filename + " is : " + result);
            }

            return result;
        } finally {
            is.close();
        }
    }

    /**
     * Recuperation des propriétés dans un fichier properties
     *
     * @param file le fichier contenant les propriétés
     * @return un objet Properties contenant les propriétés du fichier
     */
    public static Properties loadProperties(String file) throws IOException {
        Properties properties = new Properties();

        FileInputStream input = new FileInputStream(file);
        try {
            properties.load(input);
            return properties;
        } finally {
            input.close();
        }

    }

    /**
     * Recuperation des propriétés dans un fichier properties
     *
     * @param inStream le fichier contenant les propriétés
     * @return un objet Properties contenant les propriétés du fichier
     */
    public static Properties loadProperties(InputStream inStream) throws IOException, NullPointerException {
        Properties properties = new Properties();

        properties.load(inStream);
        return properties;


    }


    public ScmSession getScmSession() {
        session = ActionContext.getContext().getSession();
        Object obj = session.get("ScmSession");

        ScmSession scmSession;
        if (obj == null) {
            scmSession = new ScmSession();
            session.put("ScmSession", scmSession);
        } else {
            scmSession = (ScmSession) obj;
        }
        return scmSession;
    }

    public String getUsername(String url) {
        return getScmSession().getUsername(url);
    }

    public String getPassword(String url) {
        return getScmSession().getPassword(url);
    }


}
