/*
 * #%L
 * ScmWebEditor
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor.urlResolver;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

import org.apache.commons.lang.StringUtils;
import org.nuiton.scmwebeditor.urlResolver.impl.ScmUrlResolverDefaultImpl;

public class ScmUrlResolverEngine {

    public static final String PARAMETER_SCM_LAYOUT = "scmlayout";
    
    static final ThreadLocal<ScmUrlResolverEngine> engine = new ThreadLocal<ScmUrlResolverEngine>() {

        @Override
        protected ScmUrlResolverEngine initialValue() {
            return new ScmUrlResolverEngine();
        }
    };

    protected List<ScmUrlResolver> injectors;

    public static URL resolver(Map<String, String> parameters) throws IOException, IllegalArgumentException {

        // recuperation du layout name
        String layoutName = parameters.get(PARAMETER_SCM_LAYOUT);

        // si layout  non trouvé alors utiliser default
        if (StringUtils.isEmpty(layoutName)) {
            layoutName = ScmUrlResolverDefaultImpl.DEFAULT_NAME;
        }

        ScmUrlResolver scmURLResolver = engine.get().getScmURLResolver(layoutName);
        URL resolv = scmURLResolver.resolv(parameters);
        return resolv;
    }

    protected ScmUrlResolver getScmURLResolver(String layoutName) {
        ScmUrlResolver result = null;
        List<ScmUrlResolver> injectors = getInjectors();
        for (ScmUrlResolver injector : injectors) {
            if (layoutName.equals(injector.getLayoutName())) {
                result = injector;
                break;
            }
        }
        return result;
    }

    protected List<ScmUrlResolver> getInjectors() {
        if (injectors == null) {
            injectors = new ArrayList<ScmUrlResolver>();
            for (ScmUrlResolver injector :
                    ServiceLoader.load(ScmUrlResolver.class)) {
                injectors.add(injector);
            }
        }
        return injectors;
    }
}
