/*
 * #%L
 * ScmWebEditor
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.scmwebeditor;

import java.util.HashMap;
import java.util.Map;

public class ScmSession {

    protected Map<String, ScmUser> scmUsers;

    
    public ScmSession() {
        scmUsers = new HashMap<String,ScmUser>();
    }    

    public Map<String, ScmUser> getScmUsers() {
        return scmUsers;
    }
    
    public void addScmUser(String address , String login, String password) {
        scmUsers.put(address, new ScmUser(login,password));
    }
    
    public void delScmUser(String address) {
        scmUsers.remove(address);
    }
    
    public String getUsername(String url) {
        if(scmUsers.containsKey(url)) {
            return scmUsers.get(url).getUsername();
        }
        else {
            return null;
        }
        
    }
    
    public String getPassword(String url) {
        if(scmUsers.containsKey(url)) {
            return scmUsers.get(url).getPassword();
        }
        else {
            return null;
        }
    }
    
    public String getUUID(String address) {
        SvnConnection svnConnection = new SvnConnection(address);
        return svnConnection.getUUID();
    }
    
    
}
