/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.File;
import java.text.Normalizer;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.scmwebeditor.api.OperationNotSupportedException;
import org.nuiton.scmwebeditor.api.RepositoryNotFoundException;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.api.dto.CreateBranchDto;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.AbstractScmWebEditorAction;

public class CreateBranchAction
extends AbstractScmWebEditorAction
implements ServletRequestAware {
    private static final Log log = LogFactory.getLog(CreateBranchAction.class);
    public static final String REDIRECT = "redirect";
    protected String username;
    protected String pw;
    protected String address;
    protected boolean badLogin;
    protected boolean error;
    protected List<String> branches;
    protected String selectedBranch;
    protected String newBranchName;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPw() {
        return this.pw;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isBadLogin() {
        return this.badLogin;
    }

    public void setBadLogin(boolean badLogin) {
        this.badLogin = badLogin;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public List<String> getBranches() {
        return this.branches;
    }

    public void setBranches(List<String> branches) {
        this.branches = branches;
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }

    public void setSelectedBranch(String selectedBranch) {
        this.selectedBranch = selectedBranch;
    }

    public String getNewBranchName() {
        return this.newBranchName;
    }

    public void setNewBranchName(String newBranchName) {
        this.newBranchName = newBranchName;
    }

    public String execute() {
        String createBranchError;
        String repositoryUUID;
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        if (this.address.endsWith("/")) {
            this.address = this.address.substring(0, this.address.lastIndexOf(47));
        }
        if ((repositoryUUID = scmConn.getRepositoryId()) == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        try {
            this.branches = provider.listBranches(this.address, this.username, this.pw);
        }
        catch (OperationNotSupportedException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("The SCM " + this.scmType + " does not support branches"), (Throwable)e);
            }
            this.error = true;
            return "error";
        }
        if (this.selectedBranch == null || this.newBranchName == null) {
            return REDIRECT;
        }
        CreateBranchDto dto = new CreateBranchDto();
        dto.setAddress(this.address);
        dto.setNewBranchName(this.newBranchName);
        dto.setUsername(this.username);
        dto.setPassword(this.pw);
        dto.setPathToLocalRepos(pathToLocalRepos);
        dto.setSelectedBranch(this.selectedBranch);
        try {
            createBranchError = provider.createBranch(dto);
        }
        catch (OperationNotSupportedException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not create a branch with SCM '" + this.scmType + "'"), (Throwable)e);
            }
            this.error = true;
            return "error";
        }
        catch (AuthenticationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Authentication problem", (Throwable)e);
            }
            this.badLogin = true;
            this.username = null;
            this.pw = null;
            return "login";
        }
        catch (RepositoryNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can not reach repository at address " + this.address), (Throwable)e);
            }
            this.error = true;
            return "error";
        }
        if (createBranchError != null) {
            if (createBranchError.equals("auth error")) {
                this.badLogin = true;
                this.username = null;
                this.pw = null;
                return "login";
            }
            this.error = true;
            return "error";
        }
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

