/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: URIConverter.java 2648 2014-07-15 15:34:24Z tchemit $
 * $HeadURL: https://svn.nuiton.org/nuiton-utils/tags/nuiton-utils-3.0-rc-7/src/main/java/org/nuiton/util/converter/URIConverter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util.converter;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;

import java.net.URI;
import java.net.URISyntaxException;

import static org.apache.commons.logging.LogFactory.getLog;
import static org.nuiton.i18n.I18n.t;

/**
 * classe pour convertir une chaine en un objet URI.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3 (replace {@code org.nuiton.util.URIConverter}).
 * @deprecated since 3.0 use instead {@link org.nuiton.converter.URIConverter} (<strong>Note:</strong> This converter is no more loaded by the {@link ConverterUtil#initConverters()})
 */
@Deprecated
public class URIConverter implements Converter {

    /** Logger. */
    static Log log = getLog(URIConverter.class);

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException(
                    t("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass)) {
            Object result;
            if (isEnabled(value.getClass())) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                result = valueOf((String) value);
                return result;
            }
        }
        throw new ConversionException(
                t("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    protected URI valueOf(String value) {
        try {
            URI result;
            result = new URI(value);
            return result;
        } catch (URISyntaxException e) {
            throw new ConversionException(
                    t("nuitonutil.error.url.convertor", value, this, e.getMessage()));
        }
    }

    public URIConverter() {
        if (log.isDebugEnabled()) {
            log.debug("init uri converter " + this);
        }
    }

    protected boolean isEnabled(Class<?> aClass) {
        return URI.class.equals(aClass);
    }

    public Class<?> getType() {
        return URI.class;
    }
}
