/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * $Id: KeyStrokeConverter.java 2619 2014-02-04 06:31:17Z tchemit $
 * $HeadURL: https://nuiton.org/svn/nuiton-utils/tags/nuiton-utils-3.0-rc-3/src/main/java/org/nuiton/util/converter/KeyStrokeConverter.java $
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.converter;

import javax.swing.KeyStroke;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;

import static org.apache.commons.logging.LogFactory.getLog;
import static org.nuiton.i18n.I18n.t;

/**
 * Used to convert a {@link String} to {@link KeyStroke}.
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 2.5.1
 */
public class KeyStrokeConverter implements Converter {


    /** Logger. */
    static Log log = getLog(KeyStrokeConverter.class);

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            throw new ConversionException(
                    t("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass)) {
            Object result;
            if (isEnabled(value.getClass())) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                result = KeyStroke.getKeyStroke((String) value);
                return result;
            }
        }
        throw new ConversionException(
                t("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    protected boolean isEnabled(Class<?> aClass) {
        return KeyStroke.class.equals(aClass);
    }

    public Class<?> getType() {
        return KeyStroke.class;
    }
}
