/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.beans.Statement;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ListenerSet;

public class CategorisedListenerSet<L> {
    private static Log log = LogFactory.getLog(CategorisedListenerSet.class);
    public static final Object ALL = new Object();
    protected WeakHashMap<Object, ListenerSet<L>> listeners = new WeakHashMap();
    protected WeakHashMap<Object, Object> categoryParent = new WeakHashMap();
    protected boolean isClassCategory = true;

    public CategorisedListenerSet() {
    }

    public CategorisedListenerSet(boolean isClassCategory) {
        this();
        this.isClassCategory = isClassCategory;
    }

    protected void checkCategory(Object category) {
        if (ALL.equals(category)) {
            throw new IllegalArgumentException("ALL category can't be use to add listener or add Category");
        }
    }

    public void addCategory(Object parent, Object newCategory) {
        this.checkCategory(parent);
        this.checkCategory(newCategory);
        this.categoryParent.put(newCategory, parent);
    }

    public void add(Object category, L l) {
        this.checkCategory(category);
        ListenerSet<L> listeners = this.getListeners(category);
        listeners.add(l);
    }

    public void remove(Object category, L l) {
        ListenerSet<L> listeners = this.getListeners(category);
        listeners.remove(l);
    }

    public void fire(Object category, String methodName, Object event) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("fire category: " + category + " method: " + methodName);
        }
        ListenerSet<L> ls = this.getAllListeners(category);
        ls.fire(methodName, event);
    }

    public void fire(Object category, String methodName) throws Exception {
        for (L l : this.getAllListeners(category)) {
            Statement stm = new Statement(l, methodName, null);
            stm.execute();
        }
    }

    public Iterator<L> iterator(Object category) {
        return this.getAllListeners(category).iterator();
    }

    protected ListenerSet<L> getAllListeners(Object category) {
        ListenerSet<L> result = new ListenerSet<L>();
        if (ALL.equals(category)) {
            for (ListenerSet<L> ls : this.listeners.values()) {
                result.addAll(ls);
            }
        } else {
            Object parentCategory = category;
            while (parentCategory != null) {
                result.addAll(this.getListeners(parentCategory));
                if (this.isClassCategory && parentCategory instanceof Class) {
                    result.addAll(this.getListenersClass((Class)parentCategory));
                }
                parentCategory = this.categoryParent.get(parentCategory);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("getAllListeners category: " + category + " result: " + result);
        }
        return result;
    }

    protected ListenerSet<L> getListenersClass(Class<?> category) {
        ListenerSet<L> result = new ListenerSet<L>();
        Class<?> superClass = category.getSuperclass();
        if (superClass != null) {
            result.addAll(this.getAllListeners(superClass));
        }
        for (Class<?> c : category.getInterfaces()) {
            result.addAll(this.getAllListeners(c));
        }
        return result;
    }

    protected ListenerSet<L> getListeners(Object category) {
        ListenerSet<L> result = this.listeners.get(category);
        if (result == null) {
            result = new ListenerSet();
            this.listeners.put(category, result);
        }
        if (log != null && log.isTraceEnabled()) {
            log.trace("getListeners category: " + category + " result: " + result);
        }
        return result;
    }

    public String toString() {
        return "Listeners Category: " + this.categoryParent + "\nListener: " + this.listeners;
    }
}

