/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.I18nAble;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.RedmineModelEnum;
import org.nuiton.jredmine.model.RedmineModelScope;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.plugin.PluginHelper;

public class DisplayDataMojo
extends AbstractRedmineMojo {
    protected String types;
    protected boolean sortById;
    protected boolean anonymous;
    protected List<RedmineModelEnum> actions;

    public DisplayDataMojo() {
        super(false, false, false);
    }

    @Override
    protected boolean checkRunOnceDone() {
        return false;
    }

    @Override
    protected boolean isGoalSkip() {
        return false;
    }

    @Override
    protected boolean isRunOnce() {
        return false;
    }

    @Override
    protected void init() throws Exception {
        if (this.versionId != null) {
            this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        }
        this.actions = this.getDownloadActions(this.types, RedmineModelEnum.project, RedmineModelEnum.version, RedmineModelEnum.issue, RedmineModelEnum.news, RedmineModelEnum.issueStatus, RedmineModelEnum.issuePriority, RedmineModelEnum.issueCategory, RedmineModelEnum.tracker, RedmineModelEnum.user);
        if (this.actions == null || this.actions.isEmpty()) {
            return;
        }
        super.init();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    protected boolean checkSkip() {
        if (this.actions == null || this.actions.isEmpty()) {
            this.getLog().warn((CharSequence)"No data types detected, you must fill the required parameter types, will skip goal");
            return false;
        }
        boolean b = super.checkSkip();
        return b;
    }

    @Override
    protected void doAction() throws Exception {
        StringBuilder buffer = new StringBuilder("\n");
        for (RedmineModelEnum entry : this.actions) {
            RedmineModelScope scope = entry.getScope();
            String requestName = entry.getRequestAll();
            IdAble[] datas = (IdAble[])((RedmineServiceImplementor)this.service).getDatas(requestName, entry.getModelType(), new Object[]{this.projectId, this.versionId});
            List<IdAble> list = Arrays.asList(datas);
            if (this.sortById) {
                Collections.sort(list, ModelHelper.ID_ABLE_COMPARATOR);
            }
            buffer.append("\nValues of '").append(entry).append('\'');
            if (scope == RedmineModelScope.project || scope == RedmineModelScope.version) {
                buffer.append(" for project '").append(this.projectId).append("'");
            }
            if (scope == RedmineModelScope.version) {
                buffer.append(" and version '").append(this.versionId).append("'");
            }
            buffer.append('\n');
            for (IdAble data : list) {
                buffer.append("  - ").append(data.getId()).append(" = ").append(((I18nAble)data).getName()).append('\n');
            }
        }
        System.out.println(buffer.toString());
    }

    protected List<RedmineModelEnum> getDownloadActions(String dataTypes, RedmineModelEnum ... universe) throws MojoFailureException {
        if (universe.length == 0) {
            throw new MojoFailureException("List of accepted data types is empty!");
        }
        ArrayList<RedmineModelEnum> results = new ArrayList<RedmineModelEnum>();
        ArrayList<RedmineModelEnum> universeList = new ArrayList<RedmineModelEnum>(Arrays.asList(universe));
        for (String dataType : dataTypes.split(",")) {
            RedmineModelEnum result;
            try {
                result = RedmineModelEnum.valueOf((String)dataType.trim());
            }
            catch (Exception e) {
                throw new MojoFailureException("Unkown data type '" + dataType + "', Accepted types are : " + universeList);
            }
            if (!universeList.contains(result)) {
                throw new MojoFailureException("The data type '" + result + "' can not be used, Accepted types are : " + universeList);
            }
            RedmineModelScope scope = result.getScope();
            if (!(scope != RedmineModelScope.project && scope != RedmineModelScope.version || this.projectId != null && !this.projectId.isEmpty())) {
                throw new MojoFailureException("The data type '" + result + "', depends on a project, but the 'projectId' was not filled.");
            }
            if (scope == RedmineModelScope.version && (this.versionId == null || this.versionId.isEmpty())) {
                throw new MojoFailureException("The data type '" + result + "', depends on a version, but the 'versionId' was not filled.");
            }
            results.add(result);
        }
        return results;
    }
}

