/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.jredmine.client.RedmineRequest;
import org.nuiton.jredmine.client.RedmineRequestHelper;
import org.nuiton.jredmine.model.I18nAble;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.IdAbles;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.RedmineProjectAware;
import org.nuiton.jredmine.plugin.RedmineVersionAware;
import org.nuiton.jredmine.service.AbstractRedmineService;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="display-data", requiresOnline=true, requiresProject=true)
public class DisplayDataMojo
extends AbstractRedmineMojo
implements RedmineProjectAware,
RedmineVersionAware {
    @Parameter(property="redmine.projectId", defaultValue="${project.artifactId}", required=true)
    protected String projectId;
    @Parameter(property="redmine.versionId", defaultValue="${project.version}")
    protected String versionId;
    @Parameter(property="types", required=true)
    protected String types;
    @Parameter(property="sortById", defaultValue="true", required=true)
    protected boolean sortById;
    @Parameter(property="anonymous", defaultValue="true")
    protected boolean anonymous;
    protected List<String> actions;
    private final Map<String, Class<? extends IdAble>> namesToType;
    private final Map<String, DataScope> namestoScope = Maps.newHashMap();

    public DisplayDataMojo() {
        this.namestoScope.put("project", DataScope.NONE);
        this.namestoScope.put("version", DataScope.PROJECT);
        this.namestoScope.put("issue", DataScope.VERSION);
        this.namestoScope.put("news", DataScope.PROJECT);
        this.namestoScope.put("issuestatus", DataScope.NONE);
        this.namestoScope.put("issuepriority", DataScope.NONE);
        this.namestoScope.put("issuecategory", DataScope.PROJECT);
        this.namestoScope.put("tracker", DataScope.PROJECT);
        this.namestoScope.put("user", DataScope.PROJECT);
        this.namesToType = Maps.newHashMap();
        this.namesToType.put("project", Project.class);
        this.namesToType.put("version", Version.class);
        this.namesToType.put("issue", Issue.class);
        this.namesToType.put("news", News.class);
        this.namesToType.put("issuestatus", IssueStatus.class);
        this.namesToType.put("issuepriority", IssuePriority.class);
        this.namesToType.put("issuecategory", IssueCategory.class);
        this.namesToType.put("tracker", Tracker.class);
        this.namesToType.put("user", User.class);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    protected void init() throws Exception {
        if (this.versionId != null) {
            this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        }
        super.init();
        this.actions = this.getDownloadActions();
    }

    @Override
    protected boolean checkSkip() {
        boolean canContinue;
        if (this.actions == null || this.actions.isEmpty()) {
            this.getLog().warn((CharSequence)"No data types detected, you must fill the required parameter types, will skip goal");
            canContinue = false;
        } else {
            canContinue = super.checkSkip();
        }
        return canContinue;
    }

    @Override
    protected void doAction() throws Exception {
        StringBuilder buffer = new StringBuilder("\n");
        for (String dataTypeName : this.actions) {
            DataScope scope = this.namestoScope.get(dataTypeName);
            IdAble[] datas = DataScope.VERSION.equals((Object)scope) ? this.getDatasWithProjectAndVersion(dataTypeName) : (DataScope.PROJECT.equals((Object)scope) ? this.getDatasWithProject(dataTypeName) : this.getDatas(dataTypeName));
            List<IdAble> list = Arrays.asList(datas);
            if (this.sortById) {
                Collections.sort(list, IdAbles.ID_ABLE_COMPARATOR);
            }
            buffer.append("\nValues of '").append(dataTypeName).append('\'');
            if (DataScope.VERSION.equals((Object)scope) || DataScope.PROJECT.equals((Object)scope)) {
                buffer.append(" for project '").append(this.projectId).append("'");
            }
            if (DataScope.VERSION.equals((Object)scope)) {
                buffer.append(" and version '").append(this.versionId).append("'");
            }
            buffer.append('\n');
            for (IdAble data : list) {
                buffer.append("  - ");
                buffer.append(data.getId());
                buffer.append(" = ");
                buffer.append(((I18nAble)data).getName());
                buffer.append('\n');
            }
        }
        System.out.println(buffer.toString());
    }

    protected List<String> getDownloadActions() throws MojoFailureException {
        ArrayList results = Lists.newArrayList();
        ArrayList universeList = Lists.newArrayList(this.namestoScope.keySet());
        for (String dataType : this.types.split(",")) {
            if (!universeList.contains(dataType = dataType.toLowerCase(Locale.ENGLISH))) {
                throw new MojoFailureException("The data type '" + dataType + "' can not be used, Accepted types are : " + universeList);
            }
            DataScope scope = this.namestoScope.get(dataType);
            if ((DataScope.VERSION.equals((Object)scope) || DataScope.PROJECT.equals((Object)scope)) && (this.projectId == null || this.projectId.isEmpty())) {
                throw new MojoFailureException("The data type '" + dataType + "', depends on a project, but the 'projectId' was " + "not filled.");
            }
            if (DataScope.VERSION.equals((Object)scope) && (this.versionId == null || this.versionId.isEmpty())) {
                throw new MojoFailureException("The data type '" + dataType + "', depends on a version, but the 'versionId' was " + "not filled.");
            }
            results.add(dataType);
        }
        return results;
    }

    protected IdAble[] getDatas(String type) throws IOException {
        Class<? extends IdAble> dataType = this.namesToType.get(type);
        RedmineRequest request = RedmineRequest.get(dataType, (String[])new String[]{"jredmine"});
        if ("project".equals(type)) {
            request.path(new String[]{"get_projects.xml"});
        } else if ("issuestatus".equals(type)) {
            request.path(new String[]{"get_issue_statuses.xml"});
        } else if ("issuepriority".equals(type)) {
            request.path(new String[]{"get_issue_priorities.xml"});
        }
        IdAble[] result = (IdAble[])((AbstractRedmineService)this.service).getClient().executeRequests(request);
        return result;
    }

    protected IdAble[] getDatasWithProject(String type) throws IOException {
        Class<? extends IdAble> dataType = this.namesToType.get(type);
        String action = null;
        if ("version".equals(type)) {
            action = "get_project_versions.xml";
        } else if ("news".equals(type)) {
            action = "get_project_news.xml";
        } else if ("issuecategory".equals(type)) {
            action = "get_issue_categories.xml";
        } else if ("tracker".equals(type)) {
            action = "get_project_trackers.xml";
        } else if ("user".equals(type)) {
            action = "get_project_users.xml";
        }
        RedmineRequest request = RedmineRequestHelper.actionWithProject((String)action, dataType, (String)this.projectId);
        IdAble[] result = (IdAble[])((AbstractRedmineService)this.service).getClient().executeRequests(request);
        return result;
    }

    protected IdAble[] getDatasWithProjectAndVersion(String type) throws IOException {
        Class<? extends IdAble> dataType = this.namesToType.get(type);
        String action = null;
        if ("issue".equals(type)) {
            action = "get_version_issues.xml";
        }
        RedmineRequest request = RedmineRequestHelper.actionWithProjectAndVersion((String)action, dataType, (String)this.projectId, (String)this.versionId);
        IdAble[] result = (IdAble[])((AbstractRedmineService)this.service).getClient().executeRequests(request);
        return result;
    }

    private static enum DataScope {
        NONE,
        PROJECT,
        VERSION;

    }
}

