package org.nuiton.jredmine.plugin;
/*
 * #%L
 * JRedmine :: Maven plugin
 * $Id: AbstractRedmineMojoWithProjectAndVersion.java 314 2012-07-15 20:54:36Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.4/jredmine-maven-plugin/src/main/java/org/nuiton/jredmine/plugin/AbstractRedmineMojoWithProjectAndVersion.java $
 * %%
 * Copyright (C) 2009 - 2012 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.model.Version;

/**
 * Abstract redmine mojo which needs a redmine project and version context.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public abstract class AbstractRedmineMojoWithProjectAndVersion extends AbstractRedmineMojoWithProject implements RedmineVersionAware {

    /**
     * redmine version name.
     *
     * @since 1.0.0
     */
    @Parameter(property = "redmine.versionId", defaultValue = "${project.version}")
    protected String versionId;

    /** the version loaded in init. */
    protected Version releaseVersion;

    public AbstractRedmineMojoWithProjectAndVersion(boolean requireUser) {
        super(requireUser);
    }

    @Override
    protected boolean checkSkip() {

        boolean canContinue = super.checkSkip();

        if (canContinue) {

            if (releaseVersion == null) {
                getLog().error("the version '" + versionId + "' could not be retrieve from redmine server, goal is skip");
                canContinue = false;
            }
        }
        return canContinue;
    }

    @Override
    protected void init() throws Exception {

        super.init();

        if (initOk) {

            // check project exists

            boolean r = initReleaseVersion();
            if (!r) {
                if (isSafe()) {
                    throw new MojoExecutionException("the version '" + versionId + "' could not be retrieve from redmine server.");
                }
                initOk = false;
            }
        }
    }

    protected boolean initReleaseVersion() throws MojoExecutionException {

        if (versionId == null || versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }

        try {

            Version v = service.getVersion(projectId, versionId);

            if (v == null) {

                return false;
            }

            releaseVersion = v;
            return true;
        } catch (RedmineServiceException e) {
            getLog().warn("could not retreave version '" + versionId + "', for reason " + e.getMessage(), e);
            return false;
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    /// RedmineVersionAware
    ///////////////////////////////////////////////////////////////////////////

    @Override
    public final String getVersionId() {
        return versionId;
    }

    @Override
    public final void setVersionId(String versionId) {
        this.versionId = versionId;
    }
}
